/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.iot.mqtt.core.server.http.api.result;

import com.alibaba.fastjson.JSONObject;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import net.dreamlu.iot.mqtt.core.server.http.api.code.ResultCode;
import org.tio.http.common.HeaderName;
import org.tio.http.common.HeaderValue;
import org.tio.http.common.HttpRequest;
import org.tio.http.common.HttpResponse;

public final class Result {
    private static final Charset UTF_8 = StandardCharsets.UTF_8;
    private static final String UTF_8_NAME = UTF_8.name();

    public static HttpResponse ok() {
        return Result.ok(new HttpResponse());
    }

    public static HttpResponse ok(HttpResponse response) {
        ResultCode resultCode = ResultCode.SUCCESS;
        JSONObject json = new JSONObject();
        json.put("code", (Object)resultCode.getResultCode());
        return Result.result(response, resultCode, json);
    }

    public static HttpResponse ok(Object data) {
        return Result.ok(new HttpResponse(), data);
    }

    public static HttpResponse ok(HttpRequest request, Object data) {
        return Result.ok(new HttpResponse(request), data);
    }

    public static HttpResponse ok(HttpResponse response, Object data) {
        ResultCode resultCode = ResultCode.SUCCESS;
        JSONObject json = new JSONObject();
        json.put("code", (Object)resultCode.getResultCode());
        json.put("data", data);
        return Result.result(response, resultCode, json);
    }

    public static HttpResponse fail(ResultCode resultCode) {
        return Result.fail(new HttpResponse(), resultCode);
    }

    public static HttpResponse fail(HttpRequest request, ResultCode resultCode) {
        return Result.fail(new HttpResponse(request), resultCode);
    }

    public static HttpResponse fail(HttpResponse response, ResultCode resultCode) {
        JSONObject json = new JSONObject();
        json.put("code", (Object)resultCode.getResultCode());
        return Result.result(response, resultCode, json);
    }

    private static HttpResponse result(HttpResponse response, ResultCode resultCode, JSONObject json) {
        response.addHeader(HeaderName.Content_Type, HeaderValue.Content_Type.TEXT_PLAIN_JSON);
        response.setStatus(resultCode.getStatusCode());
        response.setBody(json.toJSONString().getBytes(UTF_8));
        response.setCharset(UTF_8_NAME);
        return response;
    }
}

