/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.iot.mqtt.core.server.http.core;

import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.ThreadPoolExecutor;
import net.dreamlu.iot.mqtt.core.server.MqttServerCreator;
import net.dreamlu.iot.mqtt.core.server.http.api.MqttHttpApi;
import net.dreamlu.iot.mqtt.core.server.http.api.auth.BasicAuthFilter;
import net.dreamlu.iot.mqtt.core.server.http.core.MqttWebServerAioHandler;
import net.dreamlu.iot.mqtt.core.server.http.handler.MqttHttpRequestHandler;
import net.dreamlu.iot.mqtt.core.server.http.handler.MqttHttpRoutes;
import net.dreamlu.iot.mqtt.core.server.http.websocket.MqttWsMsgHandler;
import org.tio.core.intf.TioHandler;
import org.tio.core.intf.TioUuid;
import org.tio.http.common.HttpConfig;
import org.tio.http.common.HttpUuid;
import org.tio.http.common.handler.HttpRequestHandler;
import org.tio.server.TioServer;
import org.tio.server.TioServerConfig;
import org.tio.server.intf.TioServerHandler;
import org.tio.server.intf.TioServerListener;
import org.tio.utils.Threads;
import org.tio.utils.hutool.StrUtil;
import org.tio.utils.thread.pool.SynThreadPoolExecutor;
import org.tio.websocket.server.handler.IWsMsgHandler;

public class MqttWebServer {
    private static final String TIO_SYSTEM_TIMER_PERIOD = "tio.system.timer.period";
    private final TioServerListener serverAioListener;
    private final HttpRequestHandler httpRequestHandler;
    private HttpConfig httpConfig = null;
    private TioServerConfig serverTioConfig = null;
    private MqttWebServerAioHandler mqttWebServerAioHandler = null;
    private TioServer tioServer = null;

    public MqttWebServer(MqttServerCreator serverCreator, TioServerListener serverAioListener, IWsMsgHandler wsMsgHandler) {
        this(serverCreator, serverAioListener, new MqttHttpRequestHandler(), wsMsgHandler, null, null);
    }

    public MqttWebServer(MqttServerCreator serverCreator, TioServerListener serverAioListener, HttpRequestHandler requestHandler, IWsMsgHandler wsMsgHandler, SynThreadPoolExecutor tioExecutor, ThreadPoolExecutor groupExecutor) {
        if (tioExecutor == null) {
            tioExecutor = Threads.getTioExecutor();
        }
        if (groupExecutor == null) {
            groupExecutor = Threads.getGroupExecutor();
        }
        this.httpRequestHandler = requestHandler;
        this.serverAioListener = serverAioListener;
        this.init(serverCreator, wsMsgHandler, tioExecutor, groupExecutor);
    }

    public HttpConfig getHttpConfig() {
        return this.httpConfig;
    }

    public HttpRequestHandler getHttpRequestHandler() {
        return this.httpRequestHandler;
    }

    public MqttWebServerAioHandler getMqttWebServerAioHandler() {
        return this.mqttWebServerAioHandler;
    }

    public TioServerConfig getServerTioConfig() {
        return this.serverTioConfig;
    }

    public TioServer getTioServer() {
        return this.tioServer;
    }

    private void init(MqttServerCreator serverCreator, IWsMsgHandler wsMsgHandler, SynThreadPoolExecutor tioExecutor, ThreadPoolExecutor groupExecutor) {
        this.httpConfig = new HttpConfig(Integer.valueOf(serverCreator.getWebPort()), false);
        this.httpConfig.setBindIp(serverCreator.getIp());
        this.httpConfig.setName(serverCreator.getName() + "-HTTP/Websocket");
        this.httpConfig.setCheckHost(false);
        this.httpConfig.setMonitorFileChange(false);
        this.httpConfig.setHttpRequestHandler(this.httpRequestHandler);
        this.mqttWebServerAioHandler = new MqttWebServerAioHandler(this.httpConfig, this.httpRequestHandler, wsMsgHandler);
        this.serverTioConfig = new TioServerConfig(this.httpConfig.getName(), (TioServerHandler)this.mqttWebServerAioHandler, this.serverAioListener, tioExecutor, groupExecutor);
        this.serverTioConfig.setSslConfig(serverCreator.getSslConfig());
        this.serverTioConfig.setHeartbeatTimeout(0L);
        this.serverTioConfig.setReadBufferSize(30720);
        this.serverTioConfig.setTioUuid((TioUuid)new HttpUuid());
        this.tioServer = new TioServer(this.serverTioConfig);
    }

    public void start() throws IOException {
        this.tioServer.start(this.httpConfig.getBindIp(), this.httpConfig.getBindPort().intValue());
    }

    public boolean stop() {
        return this.tioServer.stop();
    }

    public static MqttWebServer config(MqttServerCreator serverCreator, TioServerConfig mqttServerConfig) {
        if (serverCreator.isHttpEnable()) {
            String systemTimerPeriod = System.getProperty(TIO_SYSTEM_TIMER_PERIOD);
            if (StrUtil.isBlank((CharSequence)systemTimerPeriod)) {
                System.setProperty(TIO_SYSTEM_TIMER_PERIOD, "50");
            }
            MqttHttpApi httpApi = new MqttHttpApi(serverCreator);
            httpApi.register();
            String username = serverCreator.getHttpBasicUsername();
            String password = serverCreator.getHttpBasicPassword();
            if (Objects.nonNull(username) && Objects.nonNull(password)) {
                MqttHttpRoutes.addFilter(new BasicAuthFilter(username, password));
            }
        }
        TioHandler mqttAioHandler = mqttServerConfig.getTioHandler();
        TioServerListener mqttAioListener = (TioServerListener)mqttServerConfig.getTioListener();
        MqttWsMsgHandler mqttWsMsgHandler = new MqttWsMsgHandler(serverCreator, mqttAioHandler);
        MqttWebServer httpServerStarter = new MqttWebServer(serverCreator, mqttAioListener, mqttWsMsgHandler);
        TioServerConfig httpIioConfig = httpServerStarter.getServerTioConfig();
        httpIioConfig.share(mqttServerConfig);
        httpIioConfig.groupStat = mqttServerConfig.groupStat;
        return httpServerStarter;
    }
}

