/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.iot.mqtt.core.util.collection;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class MultiValueMap<K, V>
implements Map<K, Set<V>> {
    private final Map<K, Set<V>> targetMap;

    public MultiValueMap() {
        this(new LinkedHashMap());
    }

    public MultiValueMap(Map<K, Set<V>> targetMap) {
        this.targetMap = Objects.requireNonNull(targetMap);
    }

    public void add(K key, V value) {
        Set values = this.targetMap.computeIfAbsent(key, k -> new LinkedHashSet());
        values.add(value);
    }

    public void addAll(K key, Set<? extends V> values) {
        Set currentValues = this.targetMap.computeIfAbsent(key, k -> new LinkedHashSet());
        currentValues.addAll(values);
    }

    public void set(K key, V value) {
        LinkedHashSet<V> values = new LinkedHashSet<V>();
        values.add(value);
        this.targetMap.put(key, values);
    }

    public void setAll(Map<K, V> values) {
        values.forEach(this::set);
    }

    @Override
    public int size() {
        return this.targetMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.targetMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object o) {
        return this.targetMap.containsKey(o);
    }

    @Override
    public boolean containsValue(Object o) {
        return this.targetMap.containsValue(o);
    }

    @Override
    public Set<V> get(Object o) {
        return this.targetMap.get(o);
    }

    @Override
    public Set<V> put(K k, Set<V> vs) {
        return this.targetMap.put(k, vs);
    }

    @Override
    public Set<V> remove(Object o) {
        return this.targetMap.remove(o);
    }

    @Override
    public void putAll(Map<? extends K, ? extends Set<V>> map) {
        this.targetMap.putAll(map);
    }

    @Override
    public void clear() {
        this.targetMap.clear();
    }

    @Override
    public Set<K> keySet() {
        return this.targetMap.keySet();
    }

    @Override
    public Collection<Set<V>> values() {
        return this.targetMap.values();
    }

    @Override
    public Set<Map.Entry<K, Set<V>>> entrySet() {
        return this.targetMap.entrySet();
    }

    @Override
    public boolean equals(Object o) {
        return this.targetMap.equals(o);
    }

    @Override
    public int hashCode() {
        return this.targetMap.hashCode();
    }
}

