/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.iot.mqtt.core.util.timer;

import java.util.Objects;
import java.util.concurrent.TimeUnit;
import net.dreamlu.iot.mqtt.core.util.timer.Timer;
import net.dreamlu.iot.mqtt.core.util.timer.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AckTimerTask
extends TimerTask {
    private static final Logger log = LoggerFactory.getLogger(AckTimerTask.class);
    private final Timer timer;
    private final Runnable command;
    private final int maxRetryCount;
    private int count = 1;

    public AckTimerTask(Timer timer, Runnable command, int maxRetryCount, int retryIntervalSecs) {
        super(TimeUnit.SECONDS.toMillis(retryIntervalSecs));
        this.timer = Objects.requireNonNull(timer, "Timer is null.");
        this.command = Objects.requireNonNull(command, "Runnable command is null.");
        this.maxRetryCount = maxRetryCount;
    }

    @Override
    public void run() {
        if (++this.count <= this.maxRetryCount + 1) {
            try {
                log.info("Mqtt ack task retry running.");
                this.command.run();
                this.timer.add(this);
            }
            catch (Exception e) {
                log.error("Mqtt ack task error ", (Throwable)e);
            }
        }
    }
}

