/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.iot.mqtt.core.util.timer;

import java.util.concurrent.DelayQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Function;
import net.dreamlu.iot.mqtt.core.util.timer.Timer;
import net.dreamlu.iot.mqtt.core.util.timer.TimerTask;
import net.dreamlu.iot.mqtt.core.util.timer.TimerTaskEntry;
import net.dreamlu.iot.mqtt.core.util.timer.TimerTaskList;
import net.dreamlu.iot.mqtt.core.util.timer.TimingWheel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemTimer
implements Timer,
Function<TimerTaskEntry, Void> {
    private static final Logger logger = LoggerFactory.getLogger(SystemTimer.class);
    private final ExecutorService taskExecutor;
    private final DelayQueue<TimerTaskList> delayQueue = new DelayQueue();
    private final LongAdder taskCounter = new LongAdder();
    private final TimingWheel timingWheel;
    private final ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock.ReadLock readLock = this.readWriteLock.readLock();
    private final ReentrantReadWriteLock.WriteLock writeLock = this.readWriteLock.writeLock();

    public SystemTimer() {
        this("SystemTimerExecutor");
    }

    public SystemTimer(String executeName) {
        this(1L, 20, executeName);
    }

    public SystemTimer(long tickMs, int wheelSize, String executeName) {
        this(tickMs, wheelSize, Timer.getHiresClockMs(), executeName);
    }

    public SystemTimer(long tickMs, int wheelSize, long startMs, String executeName) {
        this.taskExecutor = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(Integer.MAX_VALUE), r -> new Thread(r, executeName));
        this.timingWheel = new TimingWheel(tickMs, wheelSize, startMs, this.taskCounter, this.delayQueue);
    }

    @Override
    public void add(TimerTask timerTask) {
        this.readLock.lock();
        try {
            this.addTimerTaskEntry(new TimerTaskEntry(timerTask, timerTask.getDelayMs() + Timer.getHiresClockMs()));
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean advanceClock(long timeoutMs) {
        TimerTaskList bucket;
        try {
            bucket = (TimerTaskList)this.delayQueue.poll(timeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
        if (bucket == null) {
            return false;
        }
        this.writeLock.lock();
        try {
            while (bucket != null) {
                this.timingWheel.advanceClock(bucket.getExpiration());
                bucket.flush(this);
                bucket = (TimerTaskList)this.delayQueue.poll();
            }
        }
        finally {
            this.writeLock.unlock();
        }
        return true;
    }

    @Override
    public long size() {
        return this.taskCounter.sum();
    }

    @Override
    public void shutdown() {
        this.taskExecutor.shutdown();
    }

    private void addTimerTaskEntry(TimerTaskEntry timerTaskEntry) {
        if (!this.timingWheel.add(timerTaskEntry) && !timerTaskEntry.cancelled()) {
            this.taskExecutor.submit(timerTaskEntry.getTimerTask());
        }
    }

    @Override
    public Void apply(TimerTaskEntry timerTaskEntry) {
        this.addTimerTaskEntry(timerTaskEntry);
        return null;
    }
}

