/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.iot.mqtt.core.util.timer;

import java.util.concurrent.DelayQueue;
import java.util.concurrent.atomic.LongAdder;
import net.dreamlu.iot.mqtt.core.util.timer.TimerTaskEntry;
import net.dreamlu.iot.mqtt.core.util.timer.TimerTaskList;

public class TimingWheel {
    private final long tickMs;
    private final int wheelSize;
    private final long interval;
    private final LongAdder taskCounter;
    private final DelayQueue<TimerTaskList> queue;
    private long currentTime;
    private volatile TimingWheel overflowWheel;
    private final TimerTaskList[] buckets;

    public TimingWheel(long tickMs, int wheelSize, long startMs, LongAdder taskCounter, DelayQueue<TimerTaskList> queue) {
        this.tickMs = tickMs;
        this.wheelSize = wheelSize;
        this.taskCounter = taskCounter;
        this.queue = queue;
        this.interval = tickMs * (long)wheelSize;
        this.currentTime = startMs - startMs % tickMs;
        this.buckets = new TimerTaskList[wheelSize];
        for (int i = 0; i < this.buckets.length; ++i) {
            this.buckets[i] = new TimerTaskList(taskCounter);
        }
    }

    public boolean add(TimerTaskEntry timerTaskEntry) {
        long expiration = timerTaskEntry.getExpirationMs();
        if (timerTaskEntry.cancelled()) {
            return false;
        }
        if (expiration < this.currentTime + this.tickMs) {
            return false;
        }
        if (expiration < this.currentTime + this.interval) {
            long virtualId = expiration / this.tickMs;
            TimerTaskList bucket = this.buckets[(int)(virtualId % (long)this.wheelSize)];
            bucket.add(timerTaskEntry);
            if (bucket.setExpiration(virtualId * this.tickMs)) {
                this.queue.offer(bucket);
            }
            return true;
        }
        if (this.overflowWheel == null) {
            this.addOverflowWheel();
        }
        return this.overflowWheel.add(timerTaskEntry);
    }

    public void advanceClock(Long timeMs) {
        if (timeMs >= this.currentTime + this.tickMs) {
            this.currentTime = timeMs - timeMs % this.tickMs;
            if (this.overflowWheel != null) {
                this.overflowWheel.advanceClock(this.currentTime);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addOverflowWheel() {
        TimingWheel timingWheel = this;
        synchronized (timingWheel) {
            if (this.overflowWheel == null) {
                this.overflowWheel = new TimingWheel(this.interval, this.wheelSize, this.currentTime, this.taskCounter, this.queue);
            }
        }
    }
}

