/*
 * Decompiled with CFR 0.152.
 */
package org.tio.client;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.AsynchronousSocketChannel;
import java.util.concurrent.atomic.AtomicInteger;
import org.tio.client.ReconnRunnable;
import org.tio.core.ChannelContext;
import org.tio.core.Node;
import org.tio.core.TioConfig;

public class ClientChannelContext
extends ChannelContext {
    private final AtomicInteger reconnCount = new AtomicInteger();
    private String bindIp;
    private Integer bindPort;
    private ReconnRunnable reconnRunnable;

    public ClientChannelContext(TioConfig tioConfig, AsynchronousSocketChannel asynchronousSocketChannel) {
        super(tioConfig, asynchronousSocketChannel);
    }

    public ClientChannelContext(TioConfig tioConfig) {
        super(tioConfig);
    }

    @Override
    public Node createClientNode(AsynchronousSocketChannel asynchronousSocketChannel) throws IOException {
        InetSocketAddress inetSocketAddress = (InetSocketAddress)asynchronousSocketChannel.getLocalAddress();
        if (inetSocketAddress == null) {
            return ClientChannelContext.createUnknownNode();
        }
        return new Node(inetSocketAddress.getHostString(), inetSocketAddress.getPort());
    }

    public String getBindIp() {
        return this.bindIp;
    }

    public void setBindIp(String bindIp) {
        this.bindIp = bindIp;
    }

    public Integer getBindPort() {
        return this.bindPort;
    }

    public void setBindPort(Integer bindPort) {
        this.bindPort = bindPort;
    }

    @Override
    public boolean isServer() {
        return false;
    }

    public ReconnRunnable getReconnRunnable() {
        return this.reconnRunnable;
    }

    public void setReconnRunnable(ReconnRunnable reconnRunnable) {
        this.reconnRunnable = reconnRunnable;
    }

    public AtomicInteger getReconnCount() {
        return this.reconnCount;
    }
}

