/*
 * Decompiled with CFR 0.152.
 */
package org.tio.client;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.channels.AsynchronousChannelGroup;
import java.nio.channels.AsynchronousSocketChannel;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.client.ClientChannelContext;
import org.tio.client.ClientGroupStat;
import org.tio.client.ConnectionCompletionHandler;
import org.tio.client.ConnectionCompletionVo;
import org.tio.client.ReconnConf;
import org.tio.client.ReconnRunnable;
import org.tio.client.TioClientConfig;
import org.tio.client.intf.TioClientHandler;
import org.tio.core.ChannelContext;
import org.tio.core.Node;
import org.tio.core.Tio;
import org.tio.core.intf.Packet;
import org.tio.core.ssl.SslFacadeContext;
import org.tio.core.stat.ChannelStat;
import org.tio.utils.hutool.StrUtil;

public class TioClient {
    private static final Logger log = LoggerFactory.getLogger(TioClient.class);
    private final TioClientConfig tioClientConfig;
    private final AsynchronousChannelGroup channelGroup;

    public TioClient(TioClientConfig tioClientConfig) throws IOException {
        this.tioClientConfig = tioClientConfig;
        this.channelGroup = AsynchronousChannelGroup.withThreadPool(tioClientConfig.groupExecutor);
        this.startHeartbeatTask();
        this.startReconnTask();
    }

    public void asyncConnect(Node serverNode) throws Exception {
        this.asyncConnect(serverNode, null);
    }

    public void asyncConnect(Node serverNode, Integer timeout) throws Exception {
        this.asyncConnect(serverNode, null, null, timeout);
    }

    public void asyncConnect(Node serverNode, String bindIp, Integer bindPort, Integer timeout) throws Exception {
        this.connect(serverNode, bindIp, bindPort, null, timeout, false);
    }

    public ClientChannelContext connect(Node serverNode) throws Exception {
        return this.connect(serverNode, null);
    }

    public ClientChannelContext connect(Node serverNode, Integer timeout) throws Exception {
        return this.connect(serverNode, null, 0, timeout);
    }

    public ClientChannelContext connect(Node serverNode, String bindIp, Integer bindPort, ClientChannelContext initClientChannelContext, Integer timeout) throws Exception {
        return this.connect(serverNode, bindIp, bindPort, initClientChannelContext, timeout, true);
    }

    private ClientChannelContext connect(Node serverNode, String bindIp, Integer bindPort, ClientChannelContext initClientChannelContext, Integer timeout, boolean isSyn) throws Exception {
        boolean isReconnect = initClientChannelContext != null;
        long start = System.currentTimeMillis();
        AsynchronousSocketChannel asynchronousSocketChannel = AsynchronousSocketChannel.open(this.channelGroup);
        long end = System.currentTimeMillis();
        long iv = end - start;
        if (iv >= 100L) {
            log.error("{}, open \u8017\u65f6:{} ms", (Object)serverNode, (Object)iv);
        }
        asynchronousSocketChannel.setOption((SocketOption)StandardSocketOptions.TCP_NODELAY, (Object)true);
        asynchronousSocketChannel.setOption((SocketOption)StandardSocketOptions.SO_REUSEADDR, (Object)true);
        asynchronousSocketChannel.setOption((SocketOption)StandardSocketOptions.SO_KEEPALIVE, (Object)true);
        InetSocketAddress bind = null;
        if (bindPort != null && bindPort > 0) {
            bind = StrUtil.isBlank((CharSequence)bindIp) ? new InetSocketAddress(bindPort) : new InetSocketAddress(bindIp, (int)bindPort);
        }
        if (bind != null) {
            asynchronousSocketChannel.bind(bind);
        }
        InetSocketAddress inetSocketAddress = new InetSocketAddress(serverNode.getIp(), serverNode.getPort());
        ConnectionCompletionVo attachment = new ConnectionCompletionVo(initClientChannelContext, this, isReconnect, asynchronousSocketChannel, serverNode, bindIp, bindPort);
        ConnectionCompletionHandler connectionCompletionHandler = this.tioClientConfig.getConnectionCompletionHandler();
        if (isSyn) {
            Integer realTimeout = timeout;
            if (realTimeout == null) {
                realTimeout = 5;
            }
            CountDownLatch countDownLatch = new CountDownLatch(1);
            attachment.setCountDownLatch(countDownLatch);
            try {
                asynchronousSocketChannel.connect(inetSocketAddress, attachment, connectionCompletionHandler);
            }
            catch (Exception e) {
                connectionCompletionHandler.failed((Throwable)e, attachment);
            }
            boolean result = countDownLatch.await(realTimeout.intValue(), TimeUnit.SECONDS);
            if (!result) {
                log.error("connect countDownLatch.await(realTimeout, TimeUnit.SECONDS) \u8fd4\u56de false");
            }
            return attachment.getChannelContext();
        }
        try {
            asynchronousSocketChannel.connect(inetSocketAddress, attachment, connectionCompletionHandler);
        }
        catch (Exception e) {
            connectionCompletionHandler.failed((Throwable)e, attachment);
        }
        return null;
    }

    public ClientChannelContext connect(Node serverNode, String bindIp, Integer bindPort, Integer timeout) throws Exception {
        return this.connect(serverNode, bindIp, bindPort, null, timeout);
    }

    public AsynchronousChannelGroup getChannelGroup() {
        return this.channelGroup;
    }

    public TioClientConfig getTioClientConfig() {
        return this.tioClientConfig;
    }

    public void reconnect(ClientChannelContext channelContext, Integer timeout) throws Exception {
        this.connect(channelContext.getServerNode(), channelContext.getBindIp(), channelContext.getBindPort(), channelContext, timeout);
    }

    private void startHeartbeatTask() {
        if (this.tioClientConfig.heartbeatTimeout <= 0L) {
            log.warn("\u7528\u6237\u53d6\u6d88\u4e86 mica-net \u7684\u5fc3\u8df3\u5b9a\u65f6\u53d1\u9001\u529f\u80fd\uff0c\u8bf7\u7528\u6237\u81ea\u5df1\u53bb\u5b8c\u6210\u5fc3\u8df3\u673a\u5236");
            return;
        }
        final ClientGroupStat clientGroupStat = (ClientGroupStat)this.tioClientConfig.groupStat;
        final TioClientHandler tioHandler = this.tioClientConfig.getTioClientHandler();
        final String id = this.tioClientConfig.getId();
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (!TioClient.this.tioClientConfig.isStopped()) {
                    Set<ChannelContext> set = ((TioClient)TioClient.this).tioClientConfig.connecteds;
                    long currTime = System.currentTimeMillis();
                    try {
                        for (ChannelContext entry : set) {
                            Packet packet;
                            ClientChannelContext channelContext = (ClientChannelContext)entry;
                            if (channelContext.isClosed || channelContext.isRemoved) continue;
                            ChannelStat stat = channelContext.stat;
                            long compareTime = Math.max(stat.latestTimeOfReceivedByte, stat.latestTimeOfSentPacket);
                            long interval = currTime - compareTime;
                            if (interval < ((TioClient)TioClient.this).tioClientConfig.heartbeatTimeout / 2L || (packet = tioHandler.heartbeatPacket(channelContext)) == null) continue;
                            boolean result = Tio.send(channelContext, packet);
                            if (!log.isInfoEnabled()) continue;
                            log.info("{} \u53d1\u9001\u5fc3\u8df3\u5305 result:{}", (Object)channelContext, (Object)result);
                        }
                        if (!((TioClient)TioClient.this).tioClientConfig.debug || !log.isInfoEnabled()) continue;
                        if (((TioClient)TioClient.this).tioClientConfig.statOn) {
                            log.info("[{}]: curr:{}, closed:{}, received:({}p)({}b), handled:{}, sent:({}p)({}b)", new Object[]{id, set.size(), clientGroupStat.closed.sum(), clientGroupStat.receivedPackets.sum(), clientGroupStat.receivedBytes.sum(), clientGroupStat.handledPackets.sum(), clientGroupStat.sentPackets.sum(), clientGroupStat.sentBytes.sum()});
                            continue;
                        }
                        log.info("[{}]: curr:{}, closed:{}", new Object[]{id, set.size(), clientGroupStat.closed.sum()});
                    }
                    catch (Throwable e) {
                        log.error("", e);
                    }
                    finally {
                        try {
                            Thread.sleep(((TioClient)TioClient.this).tioClientConfig.heartbeatTimeout / 4L);
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                            log.error(e.getMessage(), (Throwable)e);
                        }
                    }
                }
            }
        }, "tio-timer-heartbeat" + id).start();
    }

    private void startReconnTask() {
        final ReconnConf reconnConf = this.tioClientConfig.getReconnConf();
        if (reconnConf == null || reconnConf.getInterval() <= 0L) {
            return;
        }
        String id = this.tioClientConfig.getId();
        Thread thread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (!TioClient.this.tioClientConfig.isStopped()) {
                    long sleepTime;
                    int connectionSize = ((TioClient)TioClient.this).tioClientConfig.connections.size();
                    if (connectionSize > 0) {
                        log.error("connecteds:{}, closeds:{}, connections:{}", new Object[]{((TioClient)TioClient.this).tioClientConfig.connecteds.size(), ((TioClient)TioClient.this).tioClientConfig.closeds.size(), connectionSize});
                    }
                    LinkedBlockingQueue<ChannelContext> queue = reconnConf.getQueue();
                    ClientChannelContext channelContext = null;
                    try {
                        channelContext = (ClientChannelContext)queue.take();
                    }
                    catch (InterruptedException e1) {
                        Thread.currentThread().interrupt();
                        log.error(e1.getMessage(), (Throwable)e1);
                    }
                    if (channelContext == null || channelContext.isRemoved) continue;
                    SslFacadeContext sslFacadeContext = channelContext.sslFacadeContext;
                    if (sslFacadeContext != null) {
                        sslFacadeContext.setHandshakeCompleted(false);
                    }
                    if ((sleepTime = reconnConf.getInterval() - (System.currentTimeMillis() - channelContext.stat.timeInReconnQueue)) > 0L) {
                        try {
                            Thread.sleep(sleepTime);
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                            log.error(e.getMessage(), (Throwable)e);
                        }
                    }
                    if (channelContext.isRemoved || !channelContext.isClosed) continue;
                    ReconnRunnable runnable = channelContext.getReconnRunnable();
                    if (runnable == null) {
                        ClientChannelContext clientChannelContext = channelContext;
                        synchronized (clientChannelContext) {
                            runnable = channelContext.getReconnRunnable();
                            if (runnable == null) {
                                runnable = new ReconnRunnable(channelContext, TioClient.this, (Executor)reconnConf.getThreadPoolExecutor());
                                channelContext.setReconnRunnable(runnable);
                            }
                        }
                    }
                    runnable.execute();
                }
            }
        });
        thread.setName("tio-timer-reconnect-" + id);
        thread.setDaemon(true);
        thread.start();
    }

    public boolean stop() {
        boolean ret = true;
        try {
            this.tioClientConfig.groupExecutor.shutdown();
        }
        catch (Exception e1) {
            log.error(e1.getMessage(), (Throwable)e1);
        }
        try {
            this.tioClientConfig.tioExecutor.shutdown();
        }
        catch (Exception e1) {
            log.error(e1.getMessage(), (Throwable)e1);
        }
        this.tioClientConfig.setStopped(true);
        try {
            ret = ret && this.tioClientConfig.groupExecutor.awaitTermination(6000L, TimeUnit.SECONDS);
            ret = ret && this.tioClientConfig.tioExecutor.awaitTermination(6000L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            log.error(e.getMessage(), (Throwable)e);
        }
        log.info("client resource has released");
        return ret;
    }
}

