/*
 * Decompiled with CFR 0.152.
 */
package org.tio.client;

import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadPoolExecutor;
import org.tio.client.ClientGroupStat;
import org.tio.client.ConnectionCompletionHandler;
import org.tio.client.DefaultTioClientListener;
import org.tio.client.ReconnConf;
import org.tio.client.intf.TioClientHandler;
import org.tio.client.intf.TioClientListener;
import org.tio.core.ChannelContext;
import org.tio.core.TioConfig;
import org.tio.core.intf.TioHandler;
import org.tio.core.intf.TioListener;
import org.tio.core.ssl.SslConfig;
import org.tio.utils.thread.pool.SynThreadPoolExecutor;

public class TioClientConfig
extends TioConfig {
    public final Set<ChannelContext> connecteds = ConcurrentHashMap.newKeySet();
    public final Set<ChannelContext> closeds = ConcurrentHashMap.newKeySet();
    protected ReconnConf reconnConf;
    private TioClientHandler tioClientHandler = null;
    private TioClientListener tioClientListener = null;
    private ConnectionCompletionHandler connectionCompletionHandler = new ConnectionCompletionHandler();

    public TioClientConfig(TioClientHandler tioHandler, TioClientListener tioListener) {
        this(tioHandler, tioListener, null);
    }

    public TioClientConfig(TioClientHandler tioHandler, TioClientListener tioListener, ReconnConf reconnConf) {
        this(tioHandler, tioListener, reconnConf, null, null);
    }

    public TioClientConfig(TioClientHandler tioHandler, TioClientListener tioListener, ReconnConf reconnConf, SynThreadPoolExecutor tioExecutor, ThreadPoolExecutor groupExecutor) {
        super(tioExecutor, groupExecutor);
        this.groupStat = new ClientGroupStat();
        this.setTioClientHandler(tioHandler);
        this.setTioClientListener(tioListener);
        this.reconnConf = reconnConf;
    }

    public void useSsl() {
        SslConfig sslConfig = SslConfig.forClient();
        this.setSslConfig(sslConfig);
    }

    @Override
    public TioHandler getTioHandler() {
        return this.getTioClientHandler();
    }

    @Override
    public TioListener getTioListener() {
        return this.getTioClientListener();
    }

    public TioClientHandler getTioClientHandler() {
        return this.tioClientHandler;
    }

    public void setTioClientHandler(TioClientHandler tioClientHandler) {
        this.tioClientHandler = tioClientHandler;
    }

    public TioClientListener getTioClientListener() {
        return this.tioClientListener;
    }

    public void setTioClientListener(TioClientListener tioClientListener) {
        this.tioClientListener = tioClientListener;
        if (this.tioClientListener == null) {
            this.tioClientListener = new DefaultTioClientListener();
        }
    }

    public ConnectionCompletionHandler getConnectionCompletionHandler() {
        return this.connectionCompletionHandler;
    }

    public void setConnectionCompletionHandler(ConnectionCompletionHandler connectionCompletionHandler) {
        this.connectionCompletionHandler = connectionCompletionHandler;
    }

    public ReconnConf getReconnConf() {
        return this.reconnConf;
    }

    public void setReconnConf(ReconnConf reconnConf) {
        this.reconnConf = reconnConf;
    }

    @Override
    public boolean isServer() {
        return false;
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        return "TioClientConfig [name=" + this.name + "]";
    }
}

