/*
 * Decompiled with CFR 0.152.
 */
package org.tio.core;

import java.io.IOException;
import java.nio.channels.AsynchronousSocketChannel;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.Node;
import org.tio.core.ReadCompletionHandler;
import org.tio.core.Tio;
import org.tio.core.TioConfig;
import org.tio.core.WriteCompletionHandler;
import org.tio.core.intf.Packet;
import org.tio.core.ssl.SslFacadeContext;
import org.tio.core.stat.ChannelStat;
import org.tio.core.task.DecodeRunnable;
import org.tio.core.task.HandlerRunnable;
import org.tio.core.task.SendRunnable;
import org.tio.utils.hutool.StrUtil;
import org.tio.utils.prop.MapPropSupport;

public abstract class ChannelContext
extends MapPropSupport {
    public static final String UNKNOWN_ADDRESS_IP = "$UNKNOWN";
    public static final AtomicInteger UNKNOWN_ADDRESS_PORT_SEQ = new AtomicInteger();
    private static final Logger log = LoggerFactory.getLogger(ChannelContext.class);
    public final ReentrantReadWriteLock closeLock = new ReentrantReadWriteLock();
    public final ChannelStat stat = new ChannelStat();
    public final CloseMeta closeMeta = new CloseMeta();
    public boolean isReconnect = false;
    public boolean logWhenDecodeError = false;
    public Long heartbeatTimeout = null;
    public Integer packetNeededLength = null;
    public TioConfig tioConfig = null;
    public DecodeRunnable decodeRunnable = null;
    public HandlerRunnable handlerRunnable = null;
    public SendRunnable sendRunnable = null;
    public WriteCompletionHandler writeCompletionHandler = null;
    public SslFacadeContext sslFacadeContext;
    public boolean isWaitingClose = false;
    public boolean isClosed = true;
    public boolean isRemoved = false;
    public boolean isVirtual = false;
    public AsynchronousSocketChannel asynchronousSocketChannel;
    private ReadCompletionHandler readCompletionHandler = null;
    public String userId;
    private String token;
    private String bsId;
    private String id = null;
    private Node clientNode;
    private Node proxyClientNode = null;
    private Node serverNode;
    private Set<String> groups = null;
    private Integer readBufferSize = null;
    private CloseCode closeCode = CloseCode.INIT_STATUS;

    public ChannelContext(TioConfig tioConfig, AsynchronousSocketChannel asynchronousSocketChannel) {
        this.init(tioConfig, asynchronousSocketChannel);
        if (tioConfig.sslConfig != null) {
            try {
                SslFacadeContext sslFacadeContext = new SslFacadeContext(this);
                if (tioConfig.isServer()) {
                    sslFacadeContext.beginHandshake();
                }
            }
            catch (Exception e) {
                log.error("\u5728\u5f00\u59cbSSL\u63e1\u624b\u65f6\u53d1\u751f\u4e86\u5f02\u5e38", (Throwable)e);
                Tio.close(this, "\u5728\u5f00\u59cbSSL\u63e1\u624b\u65f6\u53d1\u751f\u4e86\u5f02\u5e38" + e.getMessage(), CloseCode.SSL_ERROR_ON_HANDSHAKE);
            }
        }
    }

    public ChannelContext(TioConfig tioConfig) {
        this(tioConfig, tioConfig.getTioUuid().uuid());
    }

    public ChannelContext(TioConfig tioConfig, String id) {
        this.isVirtual = true;
        this.tioConfig = tioConfig;
        this.clientNode = new Node("127.0.0.1", 26254);
        this.id = id;
        if (StrUtil.isBlank((CharSequence)id)) {
            this.id = tioConfig.getTioUuid().uuid();
        }
        this.initOther();
    }

    protected void assignAnUnknownClientNode() {
        this.setClientNode(ChannelContext.createUnknownNode());
    }

    public static Node createUnknownNode() {
        return new Node(UNKNOWN_ADDRESS_IP, UNKNOWN_ADDRESS_PORT_SEQ.incrementAndGet());
    }

    public abstract Node createClientNode(AsynchronousSocketChannel var1) throws IOException;

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        ChannelContext other = (ChannelContext)((Object)obj);
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public Node getClientNode() {
        return this.clientNode;
    }

    public void setClientNode(Node clientNode) {
        if (!this.tioConfig.isShortConnection && this.clientNode != null) {
            this.tioConfig.clientNodes.remove(this);
        }
        this.clientNode = clientNode;
        if (this.tioConfig.isShortConnection) {
            return;
        }
        if (this.clientNode != null && !Objects.equals(UNKNOWN_ADDRESS_IP, this.clientNode.getIp())) {
            this.tioConfig.clientNodes.put(this);
        }
    }

    public Set<String> getGroups() {
        return this.groups;
    }

    public String getId() {
        return this.id;
    }

    public ReadCompletionHandler getReadCompletionHandler() {
        return this.readCompletionHandler;
    }

    public Node getServerNode() {
        return this.serverNode;
    }

    public void setServerNode(Node serverNode) {
        this.serverNode = serverNode;
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public WriteCompletionHandler getWriteCompletionHandler() {
        return this.writeCompletionHandler;
    }

    public int hashCode() {
        if (StrUtil.isNotBlank((CharSequence)this.id)) {
            return this.id.hashCode();
        }
        return super.hashCode();
    }

    public void init(TioConfig tioConfig, AsynchronousSocketChannel asynchronousSocketChannel) {
        this.id = tioConfig.getTioUuid().uuid();
        this.setTioConfig(tioConfig);
        tioConfig.ids.bind(this);
        this.setAsynchronousSocketChannel(asynchronousSocketChannel);
        this.readCompletionHandler = new ReadCompletionHandler(this);
        this.writeCompletionHandler = new WriteCompletionHandler(this);
        this.logWhenDecodeError = tioConfig.logWhenDecodeError;
        this.initOther();
    }

    void initOther() {
        if (!this.tioConfig.isShortConnection) {
            this.groups = ConcurrentHashMap.newKeySet();
        }
    }

    public void processAfterSent(Packet packet, boolean isSentSuccess) {
        block11: {
            Packet.Meta meta = packet.getMeta();
            if (meta != null) {
                CountDownLatch countDownLatch = meta.getCountDownLatch();
                countDownLatch.countDown();
            }
            try {
                if (log.isDebugEnabled()) {
                    log.debug("{} \u5df2\u7ecf\u53d1\u9001 {}", (Object)this, (Object)packet.logstr());
                }
                if (this.sslFacadeContext != null && !this.sslFacadeContext.isHandshakeCompleted()) break block11;
                if (this.tioConfig.getTioListener() != null) {
                    try {
                        this.tioConfig.getTioListener().onAfterSent(this, packet, isSentSuccess);
                    }
                    catch (Exception e) {
                        log.error(e.getMessage(), (Throwable)e);
                    }
                }
                if (this.tioConfig.statOn) {
                    this.tioConfig.groupStat.sentPackets.increment();
                    this.stat.sentPackets.increment();
                }
            }
            catch (Throwable e) {
                log.error(e.getMessage(), e);
            }
        }
        if (packet.getPacketListener() != null) {
            try {
                packet.getPacketListener().onAfterSent(this, packet, isSentSuccess);
            }
            catch (Throwable e) {
                log.error(e.getMessage(), e);
            }
        }
    }

    public void setAsynchronousSocketChannel(AsynchronousSocketChannel asynchronousSocketChannel) {
        this.asynchronousSocketChannel = asynchronousSocketChannel;
        if (asynchronousSocketChannel != null) {
            try {
                this.setClientNode(this.createClientNode(asynchronousSocketChannel));
            }
            catch (IOException e) {
                log.info(e.getMessage(), (Throwable)e);
                this.assignAnUnknownClientNode();
            }
        } else {
            this.assignAnUnknownClientNode();
        }
    }

    public void setClosed(boolean isClosed) {
        this.isClosed = isClosed;
        if (isClosed && (this.clientNode == null || !UNKNOWN_ADDRESS_IP.equals(this.clientNode.getIp()))) {
            String before = this.toString();
            this.assignAnUnknownClientNode();
            log.info("\u5173\u95ed\u524d{}, \u5173\u95ed\u540e{}", (Object)before, (Object)this);
        }
    }

    public void setPacketNeededLength(Integer packetNeededLength) {
        this.packetNeededLength = packetNeededLength;
    }

    public void setReconnect(boolean isReconnect) {
        this.isReconnect = isReconnect;
    }

    public void setRemoved(boolean isRemoved) {
        this.isRemoved = isRemoved;
    }

    public void setSslFacadeContext(SslFacadeContext sslFacadeContext) {
        this.sslFacadeContext = sslFacadeContext;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(64);
        if (this.serverNode != null) {
            sb.append("server:").append(this.serverNode);
        } else {
            sb.append("server:").append("NULL");
        }
        if (this.clientNode != null) {
            sb.append(", client:").append(this.clientNode);
        } else {
            sb.append(", client:").append("NULL");
        }
        if (this.isVirtual) {
            sb.append(", virtual");
        }
        return sb.toString();
    }

    public String getBsId() {
        return this.bsId;
    }

    public void setBsId(String bsId) {
        this.bsId = bsId;
    }

    public TioConfig getTioConfig() {
        return this.tioConfig;
    }

    public void setTioConfig(TioConfig tioConfig) {
        this.tioConfig = tioConfig;
        if (tioConfig != null) {
            this.decodeRunnable = new DecodeRunnable(this, (Executor)tioConfig.tioExecutor);
            this.handlerRunnable = new HandlerRunnable(this, (Executor)tioConfig.tioExecutor);
            this.sendRunnable = new SendRunnable(this, (Executor)tioConfig.tioExecutor);
            tioConfig.connections.add(this);
        }
    }

    public abstract boolean isServer();

    public Long getHeartbeatTimeout() {
        return this.heartbeatTimeout;
    }

    public void setHeartbeatTimeout(Long heartbeatTimeout) {
        this.heartbeatTimeout = heartbeatTimeout;
    }

    public int getReadBufferSize() {
        if (this.readBufferSize != null && this.readBufferSize > 0) {
            return this.readBufferSize;
        }
        return this.tioConfig.getReadBufferSize();
    }

    public void setReadBufferSize(int readBufferSize) {
        this.readBufferSize = Math.min(readBufferSize, 132476);
    }

    public Node getProxyClientNode() {
        return this.proxyClientNode;
    }

    public void setProxyClientNode(Node proxyClientNode) {
        this.proxyClientNode = proxyClientNode;
    }

    public CloseCode getCloseCode() {
        return this.closeCode;
    }

    public void setCloseCode(CloseCode closeCode) {
        this.closeCode = closeCode;
    }

    public static class CloseMeta {
        public Throwable throwable;
        public String remark;
        public boolean isNeedRemove;

        public Throwable getThrowable() {
            return this.throwable;
        }

        public void setThrowable(Throwable throwable) {
            this.throwable = throwable;
        }

        public String getRemark() {
            return this.remark;
        }

        public void setRemark(String remark) {
            this.remark = remark;
        }

        public boolean isNeedRemove() {
            return this.isNeedRemove;
        }

        public void setNeedRemove(boolean isNeedRemove) {
            this.isNeedRemove = isNeedRemove;
        }
    }

    public static enum CloseCode {
        NO_CODE((byte)1),
        READ_ERROR((byte)2),
        WRITER_ERROR((byte)3),
        DECODE_ERROR((byte)4),
        CHANNEL_NOT_OPEN((byte)5),
        READ_COUNT_IS_ZERO((byte)6),
        CLOSED_BY_PEER((byte)7),
        READ_COUNT_IS_NEGATIVE((byte)8),
        WRITE_COUNT_IS_NEGATIVE((byte)9),
        HEARTBEAT_TIMEOUT((byte)10),
        CLIENT_CONNECTION_FAIL((byte)80),
        SSL_ERROR_ON_HANDSHAKE((byte)50),
        SSL_SESSION_CLOSED((byte)51),
        SSL_ENCRYPTION_ERROR((byte)52),
        SSL_DECRYPT_ERROR((byte)53),
        USER_CODE_0((byte)100),
        USER_CODE_1((byte)101),
        USER_CODE_2((byte)102),
        USER_CODE_3((byte)103),
        USER_CODE_4((byte)104),
        USER_CODE_5((byte)105),
        USER_CODE_6((byte)106),
        USER_CODE_7((byte)107),
        USER_CODE_8((byte)108),
        USER_CODE_9((byte)109),
        USER_CODE_10((byte)110),
        INIT_STATUS((byte)-57),
        OTHER_ERROR((byte)-56);

        final byte value;

        private CloseCode(Byte value) {
            this.value = value;
        }

        public static CloseCode from(byte value) {
            CloseCode[] values;
            for (CloseCode v : values = CloseCode.values()) {
                if (v.value != value) continue;
                return v;
            }
            return null;
        }

        public byte getValue() {
            return this.value;
        }
    }
}

