/*
 * Decompiled with CFR 0.152.
 */
package org.tio.core;

import java.nio.ByteBuffer;
import java.nio.channels.CompletionHandler;
import java.util.List;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.ChannelContext;
import org.tio.core.Tio;
import org.tio.core.TioConfig;
import org.tio.core.intf.Packet;

public class WriteCompletionHandler
implements CompletionHandler<Integer, WriteCompletionVo> {
    private static final Logger log = LoggerFactory.getLogger(WriteCompletionHandler.class);
    public final ReentrantLock lock = new ReentrantLock();
    public final Condition condition = this.lock.newCondition();
    private final ChannelContext channelContext;

    public WriteCompletionHandler(ChannelContext channelContext) {
        this.channelContext = channelContext;
    }

    @Override
    public void completed(Integer bytesWritten, WriteCompletionVo writeCompletionVo) {
        if (bytesWritten > 0) {
            this.channelContext.stat.latestTimeOfSentByte = System.currentTimeMillis();
        }
        if (writeCompletionVo.byteBuffer.hasRemaining()) {
            if (log.isInfoEnabled()) {
                log.info("{} {}/{} has sent", new Object[]{this.channelContext, writeCompletionVo.byteBuffer.position(), writeCompletionVo.byteBuffer.limit()});
            }
            this.channelContext.asynchronousSocketChannel.write(writeCompletionVo.byteBuffer, writeCompletionVo, this);
        } else {
            this.handle(bytesWritten, null, writeCompletionVo);
        }
    }

    @Override
    public void failed(Throwable throwable, WriteCompletionVo writeCompletionVo) {
        this.handle(0, throwable, writeCompletionVo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(Integer bytesWritten, Throwable throwable, WriteCompletionVo writeCompletionVo) {
        ReentrantLock lock = this.channelContext.writeCompletionHandler.lock;
        lock.lock();
        try {
            boolean isSentSuccess;
            this.channelContext.sendRunnable.canSend = true;
            this.channelContext.writeCompletionHandler.condition.signal();
            this.channelContext.stat.latestTimeOfSentPacket = System.currentTimeMillis();
            Object attachment = writeCompletionVo.obj;
            TioConfig tioConfig = this.channelContext.tioConfig;
            boolean bl = isSentSuccess = bytesWritten > 0;
            if (isSentSuccess && tioConfig.statOn) {
                tioConfig.groupStat.sentBytes.add(bytesWritten.intValue());
                this.channelContext.stat.sentBytes.add(bytesWritten.intValue());
            }
            try {
                boolean isPacket = attachment instanceof Packet;
                if (isPacket) {
                    this.handleOne(bytesWritten, throwable, (Packet)attachment, isSentSuccess);
                } else {
                    List ps = (List)attachment;
                    for (Object obj : ps) {
                        this.handleOne(bytesWritten, throwable, (Packet)obj, isSentSuccess);
                    }
                }
                if (!isSentSuccess) {
                    Tio.close(this.channelContext, throwable, "\u5199\u6570\u636e\u8fd4\u56de:" + bytesWritten, ChannelContext.CloseCode.WRITE_COUNT_IS_NEGATIVE);
                }
            }
            catch (Throwable e) {
                log.error(e.getMessage(), e);
            }
        }
        finally {
            lock.unlock();
        }
    }

    public void handleOne(Integer result, Throwable throwable, Packet packet, boolean isSentSuccess) {
        Packet.Meta meta = packet.getMeta();
        if (meta != null) {
            meta.setSentSuccess(isSentSuccess);
        }
        try {
            this.channelContext.processAfterSent(packet, isSentSuccess);
        }
        catch (Throwable e) {
            log.error(e.getMessage(), e);
        }
    }

    public static class WriteCompletionVo {
        private final ByteBuffer byteBuffer;
        private final Object obj;

        public WriteCompletionVo(ByteBuffer byteBuffer, Object obj) {
            this.byteBuffer = byteBuffer;
            this.obj = obj;
        }
    }
}

