/*
 * Decompiled with CFR 0.152.
 */
package org.tio.core.maintain;

import java.util.Comparator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.ChannelContext;
import org.tio.core.TioConfig;
import org.tio.core.intf.GroupListener;
import org.tio.utils.hutool.CollUtil;
import org.tio.utils.hutool.StrUtil;

public class Groups {
    private static final Logger log = LoggerFactory.getLogger(Groups.class);
    private final ConcurrentMap<String, Set<ChannelContext>> groupMap = new ConcurrentHashMap<String, Set<ChannelContext>>();
    private Comparator<ChannelContext> channelContextComparator = null;

    public void bind(String groupId, ChannelContext channelContext) {
        this.bind(groupId, channelContext, true);
    }

    public void bind(String groupId, ChannelContext channelContext, boolean callbackListener) {
        GroupListener groupListener;
        if (channelContext.tioConfig.isShortConnection || StrUtil.isBlank((CharSequence)groupId)) {
            return;
        }
        Set channelSet = (Set)CollUtil.computeIfAbsent(this.groupMap, (Object)groupId, key -> ConcurrentHashMap.newKeySet());
        channelSet.add(channelContext);
        channelContext.getGroups().add(groupId);
        if (callbackListener && (groupListener = channelContext.tioConfig.getGroupListener()) != null) {
            try {
                groupListener.onAfterBind(channelContext, groupId);
            }
            catch (Throwable e) {
                log.error(e.getMessage(), e);
            }
        }
    }

    public Set<ChannelContext> clients(TioConfig tioConfig, String groupId) {
        if (tioConfig.isShortConnection || StrUtil.isBlank((CharSequence)groupId)) {
            return null;
        }
        return (Set)this.groupMap.get(groupId);
    }

    public int size() {
        return this.groupMap.size();
    }

    public Set<String> groups(ChannelContext channelContext) {
        TioConfig tioConfig = channelContext.tioConfig;
        if (tioConfig.isShortConnection) {
            return null;
        }
        return channelContext.getGroups();
    }

    public void unbind(ChannelContext channelContext) {
        this.unbind(channelContext, true);
    }

    public void unbind(ChannelContext channelContext, boolean callbackListener) {
        if (channelContext.tioConfig.isShortConnection) {
            return;
        }
        Set<String> groupSet = channelContext.getGroups();
        if (groupSet == null || groupSet.isEmpty()) {
            return;
        }
        for (String groupId : groupSet) {
            try {
                this.unbind(groupId, channelContext, false, callbackListener);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        groupSet.clear();
        channelContext.getGroups().clear();
    }

    public void unbind(String groupId, ChannelContext channelContext) {
        this.unbind(groupId, channelContext, true);
    }

    public void unbind(String groupId, ChannelContext channelContext, boolean deleteFromChannelContext) {
        this.unbind(groupId, channelContext, deleteFromChannelContext, true);
    }

    public void unbind(String groupId, ChannelContext channelContext, boolean deleteFromChannelContext, boolean callbackListener) {
        GroupListener groupListener;
        if (channelContext.tioConfig.isShortConnection || StrUtil.isBlank((CharSequence)groupId)) {
            return;
        }
        Set channelSet = (Set)this.groupMap.get(groupId);
        if (channelSet == null) {
            return;
        }
        boolean ss = channelSet.remove((Object)channelContext);
        if (!ss) {
            log.warn("{}, \u79fb\u9664\u5931\u8d25,group:{} cid:{}", new Object[]{channelContext, groupId, channelContext.getId()});
        }
        if (deleteFromChannelContext) {
            channelContext.getGroups().remove(groupId);
        }
        if (callbackListener && (groupListener = channelContext.tioConfig.getGroupListener()) != null) {
            try {
                groupListener.onAfterUnbind(channelContext, groupId);
            }
            catch (Throwable e) {
                log.error(e.getMessage(), e);
            }
        }
        if (channelSet.isEmpty()) {
            this.groupMap.remove(groupId);
        }
    }

    public Comparator<ChannelContext> getChannelContextComparator() {
        return this.channelContextComparator;
    }

    public void setChannelContextComparator(Comparator<ChannelContext> channelContextComparator) {
        this.channelContextComparator = channelContextComparator;
    }
}

