/*
 * Decompiled with CFR 0.152.
 */
package org.tio.core.maintain;

import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.ChannelContext;
import org.tio.core.TioConfig;
import org.tio.utils.hutool.CollUtil;
import org.tio.utils.hutool.StrUtil;

public class Users {
    private static final Logger log = LoggerFactory.getLogger(Users.class);
    private final ConcurrentMap<String, Set<ChannelContext>> map = new ConcurrentHashMap<String, Set<ChannelContext>>();

    public void bind(String userId, ChannelContext channelContext) {
        if (channelContext.tioConfig.isShortConnection || StrUtil.isBlank((CharSequence)userId)) {
            return;
        }
        Set channelSet = (Set)CollUtil.computeIfAbsent(this.map, (Object)userId, key -> ConcurrentHashMap.newKeySet());
        channelSet.add(channelContext);
        channelContext.setUserId(userId);
    }

    public Set<ChannelContext> find(TioConfig tioConfig, String userid) {
        if (tioConfig.isShortConnection || StrUtil.isBlank((CharSequence)userid)) {
            return null;
        }
        return (Set)this.map.get(userid);
    }

    public int size() {
        return this.map.size();
    }

    public void unbind(ChannelContext channelContext) {
        if (channelContext.tioConfig.isShortConnection) {
            return;
        }
        String userId = channelContext.userId;
        if (StrUtil.isBlank((CharSequence)userId)) {
            log.debug("{}, {}, \u5e76\u6ca1\u6709\u7ed1\u5b9a\u7528\u6237", (Object)channelContext.tioConfig.getName(), (Object)channelContext);
            return;
        }
        Set contextSet = (Set)this.map.get(userId);
        if (contextSet == null) {
            log.warn("{}, {}, userid:{}, \u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684 ChannelContext set", new Object[]{channelContext.tioConfig.getName(), channelContext, userId});
            return;
        }
        contextSet.remove((Object)channelContext);
        if (contextSet.isEmpty()) {
            this.map.remove(userId);
        }
        channelContext.setUserId(null);
    }

    public void unbind(TioConfig tioConfig, String userId) {
        if (tioConfig.isShortConnection || StrUtil.isBlank((CharSequence)userId)) {
            return;
        }
        Set contextSet = (Set)this.map.get(userId);
        if (contextSet == null) {
            return;
        }
        for (ChannelContext channelContext : contextSet) {
            channelContext.setUserId(null);
        }
        contextSet.clear();
        this.map.remove(userId);
    }
}

