/*
 * Decompiled with CFR 0.152.
 */
package org.tio.core.stat;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.LongAdder;

public class ChannelStat
implements Serializable {
    private static final long serialVersionUID = -6942731710053482089L;
    public final LongAdder sentBytes = new LongAdder();
    public final LongAdder sentPackets = new LongAdder();
    public final LongAdder handledBytes = new LongAdder();
    public final LongAdder handledPackets = new LongAdder();
    public final LongAdder handledPacketCosts = new LongAdder();
    public final LongAdder receivedBytes = new LongAdder();
    public final LongAdder receivedTcps = new LongAdder();
    public final LongAdder receivedPackets = new LongAdder();
    public final AtomicInteger heartbeatTimeoutCount = new AtomicInteger();
    public int decodeFailCount = 0;
    public long latestTimeOfReceivedPacket;
    public long latestTimeOfSentPacket;
    public long latestTimeOfReceivedByte;
    public long latestTimeOfSentByte;
    public long timeCreated;
    public Long timeFirstConnected = null;
    public long timeClosed;
    public long timeInReconnQueue;

    public ChannelStat() {
        this(System.currentTimeMillis());
    }

    private ChannelStat(long now) {
        this.latestTimeOfReceivedPacket = now;
        this.latestTimeOfSentPacket = now;
        this.latestTimeOfReceivedByte = now;
        this.latestTimeOfSentByte = now;
        this.timeCreated = now;
        this.timeClosed = now;
        this.timeInReconnQueue = now;
    }

    public double getBytesPerTcpReceive() {
        if (this.receivedTcps.sum() == 0L) {
            return 0.0;
        }
        return this.receivedBytes.doubleValue() / this.receivedTcps.doubleValue();
    }

    public double getPacketsPerTcpReceive() {
        if (this.receivedTcps.sum() == 0L) {
            return 0.0;
        }
        return this.receivedPackets.doubleValue() / this.receivedTcps.doubleValue();
    }

    public int getDecodeFailCount() {
        return this.decodeFailCount;
    }

    public LongAdder getHandledBytes() {
        return this.handledBytes;
    }

    public LongAdder getHandledPackets() {
        return this.handledPackets;
    }

    public long getLatestTimeOfReceivedPacket() {
        return this.latestTimeOfReceivedPacket;
    }

    public long getLatestTimeOfSentPacket() {
        return this.latestTimeOfSentPacket;
    }

    public void setLatestTimeOfSentPacket(long latestTimeOfSentPacket) {
        this.latestTimeOfSentPacket = latestTimeOfSentPacket;
    }

    public LongAdder getReceivedBytes() {
        return this.receivedBytes;
    }

    public LongAdder getReceivedPackets() {
        return this.receivedPackets;
    }

    public LongAdder getSentBytes() {
        return this.sentBytes;
    }

    public LongAdder getSentPackets() {
        return this.sentPackets;
    }

    public long getTimeClosed() {
        return this.timeClosed;
    }

    public void setTimeClosed(long timeClosed) {
        this.timeClosed = timeClosed;
    }

    public long getTimeCreated() {
        return this.timeCreated;
    }

    public Long getTimeFirstConnected() {
        return this.timeFirstConnected;
    }

    public void setTimeFirstConnected(Long timeFirstConnected) {
        this.timeFirstConnected = timeFirstConnected;
    }

    public long getTimeInReconnQueue() {
        return this.timeInReconnQueue;
    }

    public void setTimeInReconnQueue(long timeInReconnQueue) {
        this.timeInReconnQueue = timeInReconnQueue;
    }

    public long getLatestTimeOfReceivedByte() {
        return this.latestTimeOfReceivedByte;
    }

    public void setLatestTimeOfReceivedByte(long latestTimeOfReceivedByte) {
        this.latestTimeOfReceivedByte = latestTimeOfReceivedByte;
    }

    public long getLatestTimeOfSentByte() {
        return this.latestTimeOfSentByte;
    }

    public void setLatestTimeOfSentByte(long latestTimeOfSentByte) {
        this.latestTimeOfSentByte = latestTimeOfSentByte;
    }

    public LongAdder getReceivedTcps() {
        return this.receivedTcps;
    }

    public LongAdder getHandledPacketCosts() {
        return this.handledPacketCosts;
    }

    public double getHandledCostsPerPacket() {
        if (this.handledPackets.sum() > 0L) {
            return this.handledPacketCosts.doubleValue() / this.handledPackets.doubleValue();
        }
        return 0.0;
    }
}

