/*
 * Decompiled with CFR 0.152.
 */
package org.tio.core;

import java.util.Objects;
import org.tio.utils.hutool.StrUtil;

public class Node
implements Comparable<Node> {
    private final String ip;
    private final int port;
    private byte ssl = 1;

    public Node(String ip, int port) {
        this.ip = StrUtil.isBlank((CharSequence)ip) ? "0.0.0.0" : ip;
        this.port = port;
    }

    @Override
    public int compareTo(Node other) {
        if (other == null) {
            return -1;
        }
        if (Objects.equals(this.ip, other.getIp()) && Objects.equals(this.port, other.getPort())) {
            return 0;
        }
        return this.toString().compareTo(other.toString());
    }

    public String getIp() {
        return this.ip;
    }

    public int getPort() {
        return this.port;
    }

    public String getPeerHost() {
        return this.ip + ':' + this.port;
    }

    public int hashCode() {
        return this.getPeerHost().hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Node node = (Node)o;
        return this.port == node.port && Objects.equals(this.ip, node.ip);
    }

    public String toString() {
        return this.getPeerHost();
    }

    public byte getSsl() {
        return this.ssl;
    }

    public void setSsl(byte ssl) {
        this.ssl = ssl;
    }
}

