/*
 * Decompiled with CFR 0.152.
 */
package org.tio.core.maintain;

import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.ChannelContext;
import org.tio.core.TioConfig;
import org.tio.utils.hutool.CollUtil;
import org.tio.utils.hutool.StrUtil;

public class Tokens {
    private static final Logger log = LoggerFactory.getLogger(Tokens.class);
    private final ConcurrentMap<String, Set<ChannelContext>> map = new ConcurrentHashMap<String, Set<ChannelContext>>();

    public void bind(String token, ChannelContext channelContext) {
        if (channelContext.tioConfig.isShortConnection || StrUtil.isBlank((CharSequence)token)) {
            return;
        }
        Set channelSet = (Set)CollUtil.computeIfAbsent(this.map, (Object)token, key -> ConcurrentHashMap.newKeySet());
        channelSet.add(channelContext);
        channelContext.setToken(token);
    }

    public Set<ChannelContext> find(TioConfig tioConfig, String token) {
        if (tioConfig.isShortConnection || StrUtil.isBlank((CharSequence)token)) {
            return null;
        }
        return (Set)this.map.get(token);
    }

    public int size() {
        return this.map.size();
    }

    public void unbind(ChannelContext channelContext) {
        if (channelContext.tioConfig.isShortConnection) {
            return;
        }
        String token = channelContext.getToken();
        if (StrUtil.isBlank((CharSequence)token)) {
            log.debug("{}, {}, \u5e76\u6ca1\u6709\u7ed1\u5b9aToken", (Object)channelContext.tioConfig.getName(), (Object)channelContext);
            return;
        }
        Set contextSet = (Set)this.map.get(token);
        if (contextSet == null) {
            log.warn("{}, {}, token:{}, \u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684 ChannelContext set", new Object[]{channelContext.tioConfig.getName(), channelContext, token});
            return;
        }
        channelContext.setToken(null);
        contextSet.remove((Object)channelContext);
        if (contextSet.isEmpty()) {
            this.map.remove(token);
        }
    }

    public void unbind(TioConfig tioConfig, String token) {
        if (tioConfig.isShortConnection || StrUtil.isBlank((CharSequence)token)) {
            return;
        }
        Set contextSet = (Set)this.map.get(token);
        if (contextSet == null) {
            return;
        }
        if (!contextSet.isEmpty()) {
            for (ChannelContext channelContext : contextSet) {
                channelContext.setToken(null);
            }
            contextSet.clear();
        }
        this.map.remove(token);
    }
}

