/*
 * Decompiled with CFR 0.152.
 */
package org.tio.core.utils;

import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.tio.core.utils.ByteBufferUtils;

public class DecodeByteBufferList {
    private final int listCapacity;
    private final List<ByteBuffer> list;
    private int byteSize = 0;
    private int listIndex = 0;

    public DecodeByteBufferList(int listCapacity) {
        this.listCapacity = listCapacity;
        this.list = new ArrayList<ByteBuffer>(this.listCapacity);
    }

    public DecodeByteBufferList() {
        this(10);
    }

    public List<ByteBuffer> getList() {
        return this.list;
    }

    public int getByteSize() {
        return this.byteSize;
    }

    public DecodeByteBufferList add(ByteBuffer byteBuffer) {
        if (byteBuffer.remaining() == 0) {
            byteBuffer.position(0);
        }
        byteBuffer.mark();
        if (this.listCapacity == this.list.size()) {
            ByteBuffer old = this.toByteBuffer();
            old.mark();
            this.clearList();
            this.list.add(old);
        }
        this.byteSize += byteBuffer.remaining();
        this.list.add(byteBuffer);
        return this;
    }

    public ByteBuffer checkGet(int len) {
        this.check(len);
        return this.curr();
    }

    private void clearList() {
        this.list.clear();
        this.listIndex = 0;
    }

    private boolean check(int len) {
        ByteBuffer curr = this.curr();
        int remaining = curr.remaining();
        if (remaining >= len) {
            return true;
        }
        if (this.listIndex == this.list.size() - 1) {
            throw new BufferUnderflowException();
        }
        ++this.listIndex;
        ByteBuffer next = this.list.get(this.listIndex);
        if (curr.hasRemaining()) {
            ByteBuffer next1 = ByteBufferUtils.composite(curr, next);
            next1.mark();
            curr.limit(curr.limit() - remaining);
            this.list.set(this.listIndex, next1);
        }
        return this.check(len);
    }

    public void notifySuccess() {
        ByteBuffer curr = this.curr();
        int remaining = curr.remaining();
        int removeSize = this.listIndex + 1;
        if (remaining > 0) {
            curr.mark();
            --removeSize;
        }
        for (int i = 0; i < removeSize; ++i) {
            ByteBuffer buf = this.list.get(0);
            buf.reset();
            this.byteSize -= buf.remaining();
            this.list.remove(0);
        }
        this.listIndex = 0;
    }

    public void notifyFail() {
        for (int i = 0; i < this.listIndex + 1; ++i) {
            ByteBuffer buffer = this.list.get(i);
            buffer.reset();
        }
        this.listIndex = 0;
    }

    public void notifyError() {
        this.clearList();
    }

    public void notifyStart() {
        this.listIndex = 0;
    }

    private ByteBuffer curr() {
        return this.list.get(this.listIndex);
    }

    public ByteBuffer toByteBuffer() {
        ByteBuffer all = ByteBuffer.allocate(this.byteSize);
        for (ByteBuffer byteBuffer : this.list) {
            if (byteBuffer == null) continue;
            byteBuffer.position(0);
            all.put(byteBuffer);
        }
        all.position(0);
        return all;
    }

    public byte get() {
        return this.checkGet(1).get();
    }

    public char getChar() {
        return this.checkGet(2).getChar();
    }

    public short getShort() {
        return this.checkGet(2).getShort();
    }

    public int getInt() {
        return this.checkGet(4).getInt();
    }

    public long getLong() {
        return this.checkGet(8).getLong();
    }

    public float getFloat() {
        return this.checkGet(4).getFloat();
    }

    public double getDouble() {
        return this.checkGet(8).getDouble();
    }

    public DecodeByteBufferList get(byte[] dst, int offset, int length) {
        this.checkGet(length).get(dst, offset, length);
        return this;
    }

    public DecodeByteBufferList get(byte[] dst) {
        this.checkGet(dst.length).get(dst);
        return this;
    }

    public DecodeByteBufferList skip(int len) {
        ByteBuffer buffer = this.checkGet(len);
        buffer.position(buffer.position() + len);
        return this;
    }

    public String readString(int length, Charset charset) {
        ByteBuffer buffer = this.checkGet(length);
        return ByteBufferUtils.readString(buffer, length, charset);
    }
}

