/*
 * Decompiled with CFR 0.152.
 */
package org.tio.core.ssl;

import java.io.InputStream;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.tio.core.ssl.ClientAuth;
import org.tio.utils.hutool.ResourceUtil;
import org.tio.utils.hutool.StrUtil;

public class SslConfig {
    private static final String ALGORITHM = "SunX509";
    private final ClientAuth clientAuth;
    private final SSLContext sslContext;

    public SslConfig(SSLContext sslContext) {
        this(ClientAuth.NONE, sslContext);
    }

    public SslConfig(ClientAuth clientAuth, SSLContext sslContext) {
        this.clientAuth = clientAuth;
        this.sslContext = sslContext;
    }

    public static SslConfig forServer(String keyStoreFile, String keyPasswd) {
        return SslConfig.forServer(keyStoreFile, keyPasswd, ClientAuth.NONE);
    }

    public static SslConfig forServer(String keyStoreFile, String keyPasswd, ClientAuth clientAuth) {
        return SslConfig.forServer(keyStoreFile, keyPasswd, null, null, clientAuth);
    }

    public static SslConfig forServer(String keyStoreFile, String keyPasswd, String trustStoreFile, String trustPassword, ClientAuth clientAuth) {
        return new SslConfig(clientAuth, SslConfig.getSslContext(keyStoreFile, keyPasswd, trustStoreFile, trustPassword));
    }

    public static SslConfig forServer(InputStream keyStoreInputStream, String keyPasswd) {
        return SslConfig.forServer(keyStoreInputStream, keyPasswd, ClientAuth.NONE);
    }

    public static SslConfig forServer(InputStream keyStoreInputStream, String keyPasswd, ClientAuth clientAuth) {
        return SslConfig.forServer(keyStoreInputStream, keyPasswd, null, null, clientAuth);
    }

    public static SslConfig forServer(InputStream keyStoreInputStream, String keyPasswd, InputStream trustStoreInputStream, String trustPassword, ClientAuth clientAuth) {
        return new SslConfig(clientAuth, SslConfig.getSslContext(keyStoreInputStream, keyPasswd, trustStoreInputStream, trustPassword));
    }

    public static SslConfig forClient() {
        return SslConfig.forClient((InputStream)null, null);
    }

    public static SslConfig forClient(String trustStoreFile, String trustPassword) {
        return SslConfig.forClient(null, null, trustStoreFile, trustPassword);
    }

    public static SslConfig forClient(String keyStoreFile, String keyPasswd, String trustStoreFile, String trustPassword) {
        return new SslConfig(SslConfig.getSslContext(keyStoreFile, keyPasswd, trustStoreFile, trustPassword));
    }

    public static SslConfig forClient(InputStream trustStoreInputStream, String trustPassword) {
        return new SslConfig(SslConfig.getSslContext(null, null, trustStoreInputStream, trustPassword));
    }

    public static SslConfig forClient(InputStream keyStoreInputStream, String keyPasswd, InputStream trustStoreInputStream, String trustPassword) {
        return new SslConfig(SslConfig.getSslContext(keyStoreInputStream, keyPasswd, trustStoreInputStream, trustPassword));
    }

    public static SSLContext getSslContext(String keyStoreFile, String keyPass, String trustStoreFile, String trustPass) {
        InputStream keyStoreInputStream = keyStoreFile == null ? null : (StrUtil.startWithIgnoreCase((CharSequence)keyStoreFile, (CharSequence)"classpath:") ? ResourceUtil.getResourceAsStream((String)keyStoreFile) : ResourceUtil.getFileResource((String)keyStoreFile));
        InputStream trustStoreInputStream = trustStoreFile == null ? null : (StrUtil.startWithIgnoreCase((CharSequence)trustStoreFile, (CharSequence)"classpath:") ? ResourceUtil.getResourceAsStream((String)trustStoreFile) : ResourceUtil.getFileResource((String)trustStoreFile));
        return SslConfig.getSslContext(keyStoreInputStream, keyPass, trustStoreInputStream, trustPass);
    }

    public static SSLContext getSslContext(InputStream keyStoreInputStream, String keyPass, InputStream trustInputStream, String trustPass) {
        try {
            KeyManager[] kms = null;
            TrustManager[] tms = null;
            if (keyStoreInputStream != null) {
                KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(ALGORITHM);
                KeyStore keyStore = KeyStore.getInstance("JKS");
                char[] keyPassChars = keyPass == null ? null : keyPass.toCharArray();
                keyStore.load(keyStoreInputStream, keyPassChars);
                keyManagerFactory.init(keyStore, keyPassChars);
                kms = keyManagerFactory.getKeyManagers();
            }
            if (trustInputStream != null) {
                char[] trustPassChars = trustPass == null ? null : trustPass.toCharArray();
                tms = SslConfig.getTrustManagers(trustInputStream, trustPassChars);
            }
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(kms, tms, new SecureRandom());
            return sslContext;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static TrustManager[] getTrustManagers(InputStream trustInputStream, char[] trustPassword) throws Exception {
        if (trustInputStream == null) {
            return new TrustManager[]{new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] x509Certificates, String s) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] x509Certificates, String s) {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }
            }};
        }
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(ALGORITHM);
        KeyStore keyStore = KeyStore.getInstance("JKS");
        keyStore.load(trustInputStream, trustPassword);
        trustManagerFactory.init(keyStore);
        return trustManagerFactory.getTrustManagers();
    }

    public ClientAuth getClientAuth() {
        return this.clientAuth;
    }

    public SSLContext getSslContext() {
        return this.sslContext;
    }
}

