/*
 * Decompiled with CFR 0.152.
 */
package org.tio.core;

import java.nio.ByteOrder;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.client.TioClientConfig;
import org.tio.core.ChannelContext;
import org.tio.core.PacketConverter;
import org.tio.core.PacketHandlerMode;
import org.tio.core.intf.GroupListener;
import org.tio.core.intf.Packet;
import org.tio.core.intf.TioHandler;
import org.tio.core.intf.TioListener;
import org.tio.core.intf.TioUuid;
import org.tio.core.maintain.BsIds;
import org.tio.core.maintain.ClientNodes;
import org.tio.core.maintain.Groups;
import org.tio.core.maintain.Ids;
import org.tio.core.maintain.Tokens;
import org.tio.core.maintain.Users;
import org.tio.core.ssl.SslConfig;
import org.tio.core.stat.GroupStat;
import org.tio.core.task.CloseRunnable;
import org.tio.core.uuid.DefaultTioUuid;
import org.tio.server.TioServerConfig;
import org.tio.utils.prop.MapPropSupport;
import org.tio.utils.thread.ThreadUtils;
import org.tio.utils.thread.pool.SynThreadPoolExecutor;

public abstract class TioConfig
extends MapPropSupport {
    public static final int READ_BUFFER_SIZE = Integer.getInteger("tio.default.read.buffer.size", 20480);
    public static final Set<TioServerConfig> ALL_SERVER_GROUP_CONTEXTS = new HashSet<TioServerConfig>();
    public static final Set<TioClientConfig> ALL_CLIENT_GROUP_CONTEXTS = new HashSet<TioClientConfig>();
    public static final Set<TioConfig> ALL_GROUP_CONTEXTS = new HashSet<TioConfig>();
    private static final AtomicInteger ID_ATOMIC = new AtomicInteger();
    static Logger log = LoggerFactory.getLogger(TioConfig.class);
    public final String id;
    public boolean isShortConnection = false;
    public SslConfig sslConfig = null;
    public boolean debug = false;
    public GroupStat groupStat = null;
    public boolean statOn = true;
    public PacketConverter packetConverter = null;
    public long startTime = System.currentTimeMillis();
    public boolean useQueueSend = true;
    public boolean useQueueDecode = false;
    public long heartbeatTimeout = 120000L;
    public boolean logWhenDecodeError = false;
    public PacketHandlerMode packetHandlerMode = PacketHandlerMode.SINGLE_THREAD;
    public SynThreadPoolExecutor tioExecutor;
    public CloseRunnable closeRunnable;
    public ExecutorService groupExecutor;
    public ClientNodes clientNodes = new ClientNodes();
    public Set<ChannelContext> connections = ConcurrentHashMap.newKeySet();
    public Groups groups = new Groups();
    public Users users = new Users();
    public Tokens tokens = new Tokens();
    public Ids ids = new Ids();
    public BsIds bsIds = new BsIds();
    public int maxDecodeFailCount = 10;
    public ConcurrentMap<Integer, Packet> waitingResps = new ConcurrentHashMap<Integer, Packet>();
    protected String name = "\u672a\u547d\u540d";
    private ByteOrder byteOrder = ByteOrder.BIG_ENDIAN;
    private int readBufferSize = READ_BUFFER_SIZE;
    private GroupListener groupListener = null;
    private TioUuid tioUuid = new DefaultTioUuid();
    private boolean isStopped = false;

    public TioConfig() {
        this(null, null);
    }

    public TioConfig(SynThreadPoolExecutor tioExecutor, ExecutorService groupExecutor) {
        ALL_GROUP_CONTEXTS.add(this);
        if (this instanceof TioServerConfig) {
            ALL_SERVER_GROUP_CONTEXTS.add((TioServerConfig)this);
        } else {
            ALL_CLIENT_GROUP_CONTEXTS.add((TioClientConfig)this);
        }
        if (ALL_GROUP_CONTEXTS.size() > 20) {
            log.warn("\u5df2\u7ecf\u4ea7\u751f{}\u4e2aTioConfig\u5bf9\u8c61\uff0ct-io\u4f5c\u8005\u6000\u7591\u4f60\u5728\u8bef\u7528t-io", (Object)ALL_GROUP_CONTEXTS.size());
        }
        this.id = Integer.toString(ID_ATOMIC.incrementAndGet());
        this.tioExecutor = tioExecutor;
        if (this.tioExecutor == null) {
            this.tioExecutor = ThreadUtils.getTioExecutor();
        }
        this.groupExecutor = groupExecutor;
        if (this.groupExecutor == null) {
            this.groupExecutor = ThreadUtils.getGroupExecutor();
        }
        this.closeRunnable = new CloseRunnable((Executor)this.tioExecutor);
    }

    public abstract TioHandler getTioHandler();

    public abstract TioListener getTioListener();

    public ByteOrder getByteOrder() {
        return this.byteOrder;
    }

    public void setByteOrder(ByteOrder byteOrder) {
        this.byteOrder = byteOrder;
    }

    public GroupListener getGroupListener() {
        return this.groupListener;
    }

    public void setGroupListener(GroupListener groupListener) {
        this.groupListener = groupListener;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public TioUuid getTioUuid() {
        return this.tioUuid;
    }

    public void setTioUuid(TioUuid tioUuid) {
        this.tioUuid = tioUuid;
    }

    public Map<Integer, Packet> getWaitingResps() {
        return this.waitingResps;
    }

    public boolean isStopped() {
        return this.isStopped;
    }

    public void setStopped(boolean isStopped) {
        this.isStopped = isStopped;
    }

    public void setHeartbeatTimeout(long heartbeatTimeout) {
        this.heartbeatTimeout = heartbeatTimeout;
    }

    public void setPacketHandlerMode(PacketHandlerMode packetHandlerMode) {
        this.packetHandlerMode = packetHandlerMode;
    }

    public void setShortConnection(boolean isShortConnection) {
        this.isShortConnection = isShortConnection;
    }

    public void setSslConfig(SslConfig sslConfig) {
        this.sslConfig = sslConfig;
    }

    public GroupStat getGroupStat() {
        return this.groupStat;
    }

    public void setUseQueueDecode(boolean useQueueDecode) {
        this.useQueueDecode = useQueueDecode;
    }

    public void setUseQueueSend(boolean useQueueSend) {
        this.useQueueSend = useQueueSend;
    }

    public abstract boolean isServer();

    public int getReadBufferSize() {
        return this.readBufferSize;
    }

    public void setReadBufferSize(int readBufferSize) {
        this.readBufferSize = Math.min(readBufferSize, 132476);
    }

    public boolean isSsl() {
        return this.sslConfig != null;
    }

    public void remove() {
        ALL_GROUP_CONTEXTS.remove((Object)this);
        if (this.isServer()) {
            ALL_SERVER_GROUP_CONTEXTS.remove((Object)this);
        } else {
            ALL_CLIENT_GROUP_CONTEXTS.remove((Object)this);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        TioConfig tioConfig = (TioConfig)((Object)o);
        return Objects.equals(this.id, tioConfig.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }
}

