/*
 * Decompiled with CFR 0.152.
 */
package org.tio.core.task;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.ReentrantLock;
import javax.net.ssl.SSLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.ChannelContext;
import org.tio.core.Tio;
import org.tio.core.TioConfig;
import org.tio.core.WriteCompletionHandler;
import org.tio.core.intf.Packet;
import org.tio.core.intf.TioHandler;
import org.tio.core.ssl.SslUtils;
import org.tio.core.ssl.SslVo;
import org.tio.core.utils.TioUtils;
import org.tio.utils.thread.pool.AbstractQueueRunnable;

public class SendRunnable
extends AbstractQueueRunnable<Packet> {
    private static final Logger log = LoggerFactory.getLogger(SendRunnable.class);
    private static final int MAX_CAPACITY_MIN = 131452;
    private static final int MAX_CAPACITY_MAX = 1314520;
    private final ChannelContext channelContext;
    private final TioConfig tioConfig;
    private final TioHandler tioHandler;
    private final boolean isSsl;
    private final Queue<Packet> msgQueue;
    public boolean canSend = true;
    private ConcurrentLinkedQueue<Packet> forSendAfterSslHandshakeCompleted = null;

    public SendRunnable(ChannelContext channelContext, Executor executor) {
        super(executor);
        this.channelContext = channelContext;
        this.tioConfig = channelContext.tioConfig;
        this.tioHandler = this.tioConfig.getTioHandler();
        this.isSsl = SslUtils.isSsl(this.tioConfig);
        this.msgQueue = new ConcurrentLinkedQueue<Packet>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Queue<Packet> getForSendAfterSslHandshakeCompleted(boolean forceCreate) {
        if (this.forSendAfterSslHandshakeCompleted == null && forceCreate) {
            SendRunnable sendRunnable = this;
            synchronized (sendRunnable) {
                if (this.forSendAfterSslHandshakeCompleted == null) {
                    this.forSendAfterSslHandshakeCompleted = new ConcurrentLinkedQueue();
                }
            }
        }
        return this.forSendAfterSslHandshakeCompleted;
    }

    public boolean addMsg(Packet packet) {
        if (this.isCanceled()) {
            log.info("{}, \u4efb\u52a1\u5df2\u7ecf\u53d6\u6d88\uff0c{}\u6dfb\u52a0\u5230\u53d1\u9001\u961f\u5217\u5931\u8d25", (Object)this.channelContext, (Object)packet.logstr());
            return false;
        }
        if (this.channelContext.sslFacadeContext != null && !this.channelContext.sslFacadeContext.isHandshakeCompleted() && SslUtils.needSslEncrypt(packet, this.tioConfig)) {
            return this.getForSendAfterSslHandshakeCompleted(true).add(packet);
        }
        return this.msgQueue.add(packet);
    }

    public void clearMsgQueue() {
        Packet p;
        this.forSendAfterSslHandshakeCompleted = null;
        while ((p = this.msgQueue.poll()) != null) {
            try {
                this.channelContext.processAfterSent(p, false);
            }
            catch (Throwable e) {
                log.error(e.getMessage(), e);
            }
        }
    }

    private ByteBuffer getByteBuffer(Packet packet) {
        try {
            ByteBuffer byteBuffer = packet.getPreEncodedByteBuffer();
            if (byteBuffer == null) {
                byteBuffer = this.tioHandler.encode(packet, this.tioConfig, this.channelContext);
            }
            if (!byteBuffer.hasRemaining()) {
                byteBuffer.flip();
            }
            return byteBuffer;
        }
        catch (Exception e) {
            log.error(packet.logstr(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public void runTask() {
        Packet packet;
        if (this.msgQueue.isEmpty()) {
            return;
        }
        int queueSize = this.msgQueue.size();
        if (queueSize == 1) {
            Packet packet2 = this.msgQueue.poll();
            if (packet2 != null) {
                this.sendPacket(packet2);
            }
            return;
        }
        int listInitialCapacity = Math.min(queueSize, this.canSend ? 300 : 1000);
        ArrayList<Packet> packets = new ArrayList<Packet>(listInitialCapacity);
        ArrayList<ByteBuffer> byteBuffers = new ArrayList<ByteBuffer>(listInitialCapacity);
        int allBytebufferCapacity = 0;
        Boolean needSslEncrypted = null;
        boolean sslChanged = false;
        while ((packet = this.msgQueue.poll()) != null) {
            ByteBuffer byteBuffer = this.getByteBuffer(packet);
            packets.add(packet);
            byteBuffers.add(byteBuffer);
            allBytebufferCapacity += byteBuffer.limit();
            if (this.isSsl) {
                boolean _needSslEncrypted;
                boolean bl = _needSslEncrypted = !packet.isSslEncrypted();
                sslChanged = needSslEncrypted == null ? false : needSslEncrypted != _needSslEncrypted;
                needSslEncrypted = _needSslEncrypted;
            }
            if ((!this.canSend || allBytebufferCapacity < 131452) && allBytebufferCapacity < 1314520 && !sslChanged) continue;
            break;
        }
        if (allBytebufferCapacity == 0) {
            return;
        }
        ByteBuffer allByteBuffer = ByteBuffer.allocate(allBytebufferCapacity);
        for (ByteBuffer byteBuffer : byteBuffers) {
            allByteBuffer.put(byteBuffer);
        }
        allByteBuffer.flip();
        if (this.isSsl && needSslEncrypted.booleanValue()) {
            SslVo sslVo = new SslVo(allByteBuffer, packets);
            try {
                this.channelContext.sslFacadeContext.getSslFacade().encrypt(sslVo);
                allByteBuffer = sslVo.getByteBuffer();
            }
            catch (SSLException e) {
                log.error("{}, \u8fdb\u884cSSL\u52a0\u5bc6\u65f6\u53d1\u751f\u4e86\u5f02\u5e38", (Object)this.channelContext, (Object)e);
                Tio.close(this.channelContext, "\u8fdb\u884cSSL\u52a0\u5bc6\u65f6\u53d1\u751f\u4e86\u5f02\u5e38", ChannelContext.CloseCode.SSL_ENCRYPTION_ERROR);
                return;
            }
        }
        this.sendByteBuffer(allByteBuffer, packets);
    }

    public boolean sendPacket(Packet packet) {
        ByteBuffer byteBuffer = this.getByteBuffer(packet);
        if (this.isSsl && !packet.isSslEncrypted()) {
            SslVo sslVo = new SslVo(byteBuffer, packet);
            try {
                this.channelContext.sslFacadeContext.getSslFacade().encrypt(sslVo);
                byteBuffer = sslVo.getByteBuffer();
            }
            catch (SSLException e) {
                log.error("{}, \u8fdb\u884cSSL\u52a0\u5bc6\u65f6\u53d1\u751f\u4e86\u5f02\u5e38", (Object)this.channelContext, (Object)e);
                Tio.close(this.channelContext, "\u8fdb\u884cSSL\u52a0\u5bc6\u65f6\u53d1\u751f\u4e86\u5f02\u5e38", ChannelContext.CloseCode.SSL_ENCRYPTION_ERROR);
                return false;
            }
        }
        this.sendByteBuffer(byteBuffer, packet);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendByteBuffer(ByteBuffer byteBuffer, Object packets) {
        if (byteBuffer == null) {
            log.error("{},byteBuffer is null", (Object)this.channelContext);
            return;
        }
        if (!TioUtils.checkBeforeIO(this.channelContext)) {
            return;
        }
        ReentrantLock lock = this.channelContext.writeCompletionHandler.lock;
        lock.lock();
        try {
            this.canSend = false;
            WriteCompletionHandler.WriteCompletionVo writeCompletionVo = new WriteCompletionHandler.WriteCompletionVo(byteBuffer, packets);
            this.channelContext.asynchronousSocketChannel.write(byteBuffer, writeCompletionVo, this.channelContext.writeCompletionHandler);
            this.channelContext.writeCompletionHandler.condition.await();
        }
        catch (InterruptedException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            lock.unlock();
        }
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + ':' + this.channelContext.toString();
    }

    public String logstr() {
        return this.toString();
    }

    public Queue<Packet> getMsgQueue() {
        return this.msgQueue;
    }
}

