/*
 * Decompiled with CFR 0.152.
 */
package org.tio.server.cluster.core;

import java.nio.ByteBuffer;
import org.tio.core.ChannelContext;
import org.tio.core.Tio;
import org.tio.core.TioConfig;
import org.tio.core.exception.TioDecodeException;
import org.tio.core.intf.Packet;
import org.tio.server.cluster.codec.ClusterMessageDecoder;
import org.tio.server.cluster.codec.ClusterMessageEncoder;
import org.tio.server.cluster.core.ClusterImpl;
import org.tio.server.cluster.core.ClusterMessageListener;
import org.tio.server.cluster.message.AbsClusterMessage;
import org.tio.server.cluster.message.ClusterDataMessage;
import org.tio.server.cluster.message.ClusterJoinMessage;
import org.tio.server.cluster.message.ClusterPingMessage;
import org.tio.server.cluster.message.ClusterPongMessage;
import org.tio.server.cluster.message.ClusterSyncMessage;
import org.tio.server.intf.TioServerHandler;

public class ClusterTcpServerHandler
implements TioServerHandler {
    private final ClusterImpl clusterApi;
    private final ClusterMessageEncoder messageEncoder;
    private final ClusterMessageDecoder messageDecoder;
    private final ClusterMessageListener messageListener;

    public ClusterTcpServerHandler(ClusterImpl clusterApi, ClusterMessageDecoder messageDecoder, ClusterMessageListener messageListener) {
        this.clusterApi = clusterApi;
        this.messageEncoder = ClusterMessageEncoder.INSTANCE;
        this.messageDecoder = messageDecoder;
        this.messageListener = messageListener;
    }

    @Override
    public Packet decode(ByteBuffer buffer, int limit, int position, int readableLength, ChannelContext context) throws TioDecodeException {
        return this.messageDecoder.decode(context, buffer, readableLength);
    }

    @Override
    public ByteBuffer encode(Packet packet, TioConfig tioConfig, ChannelContext context) {
        return this.messageEncoder.encode(context, (AbsClusterMessage)packet);
    }

    @Override
    public void handler(Packet packet, ChannelContext context) throws Exception {
        if (packet instanceof ClusterPingMessage) {
            ClusterTcpServerHandler.handlerPingMessage(context);
        } else if (packet instanceof ClusterSyncMessage) {
            this.handlerSyncMessage(context, (ClusterSyncMessage)packet);
        } else if (packet instanceof ClusterDataMessage) {
            this.handlerDataMessage((ClusterDataMessage)packet);
        } else if (packet instanceof ClusterJoinMessage) {
            this.handlerJoinMessage((ClusterJoinMessage)packet);
        }
    }

    private static void handlerPingMessage(ChannelContext context) {
        Tio.send(context, ClusterPongMessage.INSTANCE);
    }

    private void handlerSyncMessage(ChannelContext context, ClusterSyncMessage message) {
        this.messageListener.onMessage(message);
        Tio.send(context, message.toAckMessage());
    }

    private void handlerDataMessage(ClusterDataMessage message) {
        this.messageListener.onMessage(message);
    }

    private void handlerJoinMessage(ClusterJoinMessage message) {
        this.clusterApi.addJoinMember(message.getJoinMember());
    }
}

