/*
 * Decompiled with CFR 0.152.
 */
package org.tio.client;

import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.CompletionHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.client.ClientChannelContext;
import org.tio.client.ConnectionCompletionVo;
import org.tio.client.ReconnConf;
import org.tio.client.TioClient;
import org.tio.client.TioClientConfig;
import org.tio.client.intf.TioClientListener;
import org.tio.core.ChannelContext;
import org.tio.core.Node;
import org.tio.core.ReadCompletionHandler;
import org.tio.core.Tio;
import org.tio.core.TioConfig;
import org.tio.core.ssl.SslFacadeContext;
import org.tio.core.ssl.SslUtils;

public class ConnectionCompletionHandler
implements CompletionHandler<Void, ConnectionCompletionVo> {
    private static final Logger log = LoggerFactory.getLogger(ConnectionCompletionHandler.class);

    @Override
    public void completed(Void result, ConnectionCompletionVo attachment) {
        ConnectionCompletionHandler.handler(result, attachment, null);
    }

    @Override
    public void failed(Throwable throwable, ConnectionCompletionVo attachment) {
        ConnectionCompletionHandler.handler(null, attachment, throwable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void handler(Void result, ConnectionCompletionVo attachment, Throwable throwable) {
        ClientChannelContext channelContext = attachment.getChannelContext();
        AsynchronousSocketChannel asynchronousSocketChannel = attachment.getAsynchronousSocketChannel();
        TioClient tioClient = attachment.getTioClient();
        TioClientConfig tioClientConfig = tioClient.getTioClientConfig();
        Node serverNode = attachment.getServerNode();
        String bindIp = attachment.getBindIp();
        Integer bindPort = attachment.getBindPort();
        TioClientListener tioClientListener = tioClientConfig.getTioClientListener();
        boolean isReconnect = attachment.isReconnect();
        boolean isConnected = false;
        try {
            if (throwable == null) {
                if (isReconnect) {
                    channelContext.setAsynchronousSocketChannel(asynchronousSocketChannel);
                    channelContext.handlerRunnable.setCanceled(false);
                    channelContext.sendRunnable.setCanceled(false);
                    tioClientConfig.closeds.remove((Object)channelContext);
                } else {
                    channelContext = new ClientChannelContext((TioConfig)tioClientConfig, asynchronousSocketChannel);
                    channelContext.setServerNode(serverNode);
                }
                channelContext.setBindIp(bindIp);
                channelContext.setBindPort(bindPort);
                channelContext.getReconnCount().set(0);
                channelContext.setClosed(false);
                isConnected = true;
                attachment.setChannelContext(channelContext);
                tioClientConfig.connecteds.add(channelContext);
                ReadCompletionHandler readCompletionHandler = channelContext.getReadCompletionHandler();
                ByteBuffer readByteBuffer = readCompletionHandler.getReadByteBuffer();
                readByteBuffer.position(0);
                readByteBuffer.limit(readByteBuffer.capacity());
                asynchronousSocketChannel.read(readByteBuffer, readByteBuffer, readCompletionHandler);
                log.info("connected to {}", (Object)serverNode);
                if (!isReconnect) {
                    channelContext.stat.setTimeFirstConnected(System.currentTimeMillis());
                }
            } else {
                boolean f;
                ReconnConf reconnConf;
                log.error(throwable.getMessage(), throwable);
                if (channelContext == null && (reconnConf = tioClientConfig.getReconnConf()) != null) {
                    channelContext = new ClientChannelContext((TioConfig)tioClientConfig, asynchronousSocketChannel);
                    channelContext.setServerNode(serverNode);
                }
                if (!isReconnect && channelContext != null) {
                    attachment.setChannelContext(channelContext);
                }
                if (!(f = ReconnConf.put(channelContext))) {
                    Tio.close(channelContext, null, "\u4e0d\u9700\u8981\u91cd\u8fde\uff0c\u5173\u95ed\u8be5\u8fde\u63a5", true, false, ChannelContext.CloseCode.CLIENT_CONNECTION_FAIL);
                }
            }
        }
        catch (Throwable e) {
            log.error(e.getMessage(), e);
        }
        finally {
            if (attachment.getCountDownLatch() != null) {
                attachment.getCountDownLatch().countDown();
            }
            try {
                if (channelContext != null) {
                    channelContext.setReconnect(isReconnect);
                    if (SslUtils.isSsl(channelContext.tioConfig)) {
                        if (isConnected) {
                            SslFacadeContext sslFacadeContext = channelContext.getSslFacadeContext();
                            sslFacadeContext.beginHandshake();
                        } else if (tioClientListener != null) {
                            tioClientListener.onAfterConnected(channelContext, false, isReconnect);
                        }
                    } else if (tioClientListener != null) {
                        tioClientListener.onAfterConnected(channelContext, isConnected, isReconnect);
                    }
                }
            }
            catch (Throwable e1) {
                log.error(e1.getMessage(), e1);
            }
        }
    }
}

