/*
 * Decompiled with CFR 0.152.
 */
package org.tio.core.ssl.facade;

import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.ChannelContext;
import org.tio.core.ssl.SslVo;
import org.tio.core.ssl.facade.IHandshakeCompletedListener;
import org.tio.core.ssl.facade.ISessionClosedListener;
import org.tio.core.ssl.facade.ITaskHandler;
import org.tio.core.ssl.facade.Tasks;
import org.tio.core.ssl.facade.Worker;
import org.tio.server.ServerChannelContext;

class Handshaker {
    private static final Logger log = LoggerFactory.getLogger(Handshaker.class);
    private final ITaskHandler _taskHandler;
    private final Worker _worker;
    private final ChannelContext channelContext;
    private boolean _finished;
    private IHandshakeCompletedListener _hscl;
    private ISessionClosedListener _sessionClosedListener;

    public Handshaker(Worker worker, ITaskHandler taskHandler, ChannelContext channelContext) {
        this.channelContext = channelContext;
        this._worker = worker;
        this._taskHandler = taskHandler;
        this._finished = false;
    }

    void addCompletedListener(IHandshakeCompletedListener hscl) {
        this._hscl = hscl;
    }

    void begin() throws SSLException {
        this._worker.beginHandshake();
        this.shakehands();
    }

    void carryOn() throws SSLException {
        this.shakehands();
    }

    void handleUnwrapResult(SSLEngineResult result) throws SSLException {
        if (result.getHandshakeStatus().equals((Object)SSLEngineResult.HandshakeStatus.FINISHED)) {
            this.handshakeFinished();
        } else {
            this.shakehands();
        }
    }

    public void handshakeFinished() {
        this._finished = true;
        if (this._hscl != null) {
            this._hscl.onComplete();
            this._hscl = null;
        } else if (log.isDebugEnabled()) {
            log.debug("----- hscl has finished");
        }
    }

    boolean isFinished() {
        return this._finished;
    }

    void removeCompletedListener(IHandshakeCompletedListener hscl) {
        this._hscl = hscl;
    }

    public ISessionClosedListener getSessionClosedListener() {
        return this._sessionClosedListener;
    }

    public void setSessionClosedListener(ISessionClosedListener sessionClosedListener) {
        this._sessionClosedListener = sessionClosedListener;
    }

    private void shakehands() throws SSLException {
        SSLEngineResult.HandshakeStatus handshakeStatus = this._worker.getHandshakeStatus();
        if (log.isDebugEnabled()) {
            log.debug("{}, \u63e1\u624b\u72b6\u6001 handshakeStatus:{}", (Object)this.channelContext, (Object)handshakeStatus);
        }
        switch (handshakeStatus) {
            case NOT_HANDSHAKING: {
                if (!log.isDebugEnabled()) break;
                log.debug("{}, \u63e1\u624b\u65e9\u5c31\u5b8c\u6210\u4e86\uff0c handshakeStatus:{}", (Object)this.channelContext, (Object)handshakeStatus);
                break;
            }
            case FINISHED: {
                this.handshakeFinished();
                break;
            }
            case NEED_TASK: {
                this._taskHandler.process(new Tasks(this._worker, this));
                break;
            }
            case NEED_WRAP: {
                SSLEngineResult wResult = this._worker.wrap(new SslVo(), null);
                if (wResult.getStatus().equals((Object)SSLEngineResult.Status.CLOSED) && null != this._sessionClosedListener) {
                    this._sessionClosedListener.onSessionClosed();
                }
                if (wResult.getHandshakeStatus().equals((Object)SSLEngineResult.HandshakeStatus.FINISHED)) {
                    if (!(this.channelContext instanceof ServerChannelContext)) break;
                    this.handshakeFinished();
                    break;
                }
                this.shakehands();
                break;
            }
            case NEED_UNWRAP: {
                if (this._worker.pendingUnwrap()) {
                    SSLEngineResult u_result = this._worker.unwrap(null);
                    if (log.isDebugEnabled()) {
                        log.debug("Unwrap result {}", (Object)u_result);
                    }
                    if (u_result.getHandshakeStatus().equals((Object)SSLEngineResult.HandshakeStatus.FINISHED)) {
                        this.handshakeFinished();
                    }
                    if (!u_result.getStatus().equals((Object)SSLEngineResult.Status.OK)) break;
                    this.shakehands();
                    break;
                }
                if (!log.isDebugEnabled()) break;
                log.debug("No pending data to unwrap");
                break;
            }
        }
    }
}

