/*
 * Decompiled with CFR 0.152.
 */
package org.tio.server;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.net.InetSocketAddress;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.channels.AsynchronousChannelGroup;
import java.nio.channels.AsynchronousServerSocketChannel;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.Node;
import org.tio.server.AcceptCompletionHandler;
import org.tio.server.TioServerConfig;
import org.tio.server.task.ServerHeartbeatTask;
import org.tio.utils.Version;
import org.tio.utils.hutool.DateUtil;
import org.tio.utils.hutool.StrUtil;
import org.tio.utils.timer.DefaultTimerTaskService;
import org.tio.utils.timer.Timer;
import org.tio.utils.timer.TimerTaskService;

public class TioServer {
    private static final Logger log = LoggerFactory.getLogger(TioServer.class);
    private final TioServerConfig serverConfig;
    private final TimerTaskService taskService;
    private AsynchronousServerSocketChannel serverSocketChannel;
    private AsynchronousChannelGroup channelGroup = null;
    private Node serverNode;
    private boolean isWaitingStop = false;

    public TioServer(TioServerConfig serverConfig) {
        this.serverConfig = serverConfig;
        this.taskService = TioServer.getTimerTaskService(serverConfig.getTaskService());
    }

    private static TimerTaskService getTimerTaskService(TimerTaskService taskService) {
        return taskService == null ? new DefaultTimerTaskService() : taskService;
    }

    public TioServerConfig getServerConfig() {
        return this.serverConfig;
    }

    public Node getServerNode() {
        return this.serverNode;
    }

    public AsynchronousServerSocketChannel getServerSocketChannel() {
        return this.serverSocketChannel;
    }

    public boolean isWaitingStop() {
        return this.isWaitingStop;
    }

    private void startHeartbeatTask() {
        this.taskService.start();
        if (this.serverConfig.heartbeatTimeout > 0L) {
            this.taskService.addTask(systemTimer -> new ServerHeartbeatTask((Timer)systemTimer, this.serverConfig));
        } else if (this.serverConfig.isNeedCheckHeartbeat()) {
            log.warn("\u7528\u6237\u53d6\u6d88\u4e86 mica-net \u7684\u5fc3\u8df3\u5b9a\u65f6\u53d1\u9001\u529f\u80fd\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u81ea\u5b9a\u4e49\u5fc3\u8df3\u673a\u5236");
        }
    }

    public void start(String serverIp, int serverPort) throws IOException {
        long start = System.currentTimeMillis();
        this.startHeartbeatTask();
        this.serverNode = new Node(serverIp, serverPort);
        this.channelGroup = AsynchronousChannelGroup.withThreadPool(this.serverConfig.groupExecutor);
        this.serverSocketChannel = AsynchronousServerSocketChannel.open(this.channelGroup);
        this.serverSocketChannel.setOption((SocketOption)StandardSocketOptions.SO_REUSEADDR, (Object)true);
        this.serverSocketChannel.setOption((SocketOption)StandardSocketOptions.SO_RCVBUF, (Object)65536);
        InetSocketAddress listenAddress = StrUtil.isBlank((CharSequence)serverIp) ? new InetSocketAddress(serverPort) : new InetSocketAddress(serverIp, serverPort);
        this.serverSocketChannel.bind(listenAddress, 0);
        AcceptCompletionHandler acceptCompletionHandler = this.serverConfig.getAcceptCompletionHandler();
        this.serverSocketChannel.accept(this, acceptCompletionHandler);
        this.serverConfig.startTime = System.currentTimeMillis();
        String baseStr = "|----------------------------------------------------------------------------------------|";
        int baseLen = baseStr.length();
        StackTraceElement[] ses = Thread.currentThread().getStackTrace();
        StackTraceElement se = ses[ses.length - 1];
        int xxLen = 18;
        int aaLen = baseLen - 3;
        ArrayList<String> infoList = new ArrayList<String>();
        infoList.add(StrUtil.fillAfter((String)"TioConfig name", (char)' ', (int)xxLen) + "| " + this.serverConfig.getName());
        infoList.add(StrUtil.fillAfter((String)"Mica net version", (char)' ', (int)xxLen) + "| " + Version.getVersion());
        infoList.add(StrUtil.fillAfter((String)"Started at", (char)' ', (int)xxLen) + "| " + DateUtil.formatDateTime((LocalDateTime)LocalDateTime.now()));
        infoList.add(StrUtil.fillAfter((String)"Listen on", (char)' ', (int)xxLen) + "| " + this.serverNode);
        infoList.add(StrUtil.fillAfter((String)"Main Class", (char)' ', (int)xxLen) + "| " + se.getClassName());
        try {
            RuntimeMXBean runtimeMxBean = ManagementFactory.getRuntimeMXBean();
            String runtimeName = runtimeMxBean.getName();
            String pid = runtimeName.split("@")[0];
            long startTime = runtimeMxBean.getStartTime();
            long startCost = System.currentTimeMillis() - startTime;
            infoList.add(StrUtil.fillAfter((String)"Jvm start time", (char)' ', (int)xxLen) + "| " + startCost + "ms");
            infoList.add(StrUtil.fillAfter((String)"Tio start time", (char)' ', (int)xxLen) + "| " + (System.currentTimeMillis() - start) + "ms");
            infoList.add(StrUtil.fillAfter((String)"Pid", (char)' ', (int)xxLen) + "| " + pid);
        }
        catch (Exception runtimeMxBean) {
            // empty catch block
        }
        StringBuilder printStr = new StringBuilder("\r\n" + baseStr + "\r\n");
        for (String string : infoList) {
            printStr.append("| ").append(StrUtil.fillAfter((String)string, (char)' ', (int)aaLen)).append("|\r\n");
        }
        printStr.append(baseStr).append("\r\n");
        if (log.isInfoEnabled()) {
            log.info(printStr.toString());
        } else {
            System.out.println(printStr);
        }
    }

    public boolean stop() {
        boolean ret;
        this.isWaitingStop = true;
        this.serverConfig.remove();
        this.taskService.stop();
        try {
            this.channelGroup.shutdownNow();
        }
        catch (Exception e) {
            log.error("channelGroup.shutdownNow()\u65f6\u62a5\u9519", (Throwable)e);
        }
        try {
            this.serverSocketChannel.close();
        }
        catch (Exception e1) {
            log.error("serverSocketChannel.close()\u65f6\u62a5\u9519", (Throwable)e1);
        }
        this.serverConfig.setStopped(true);
        try {
            this.serverConfig.groupExecutor.shutdown();
        }
        catch (Exception e1) {
            log.error(e1.getMessage(), (Throwable)e1);
        }
        try {
            this.serverConfig.tioExecutor.shutdown();
        }
        catch (Exception e1) {
            log.error(e1.getMessage(), (Throwable)e1);
        }
        try {
            ret = this.serverConfig.groupExecutor.awaitTermination(6000L, TimeUnit.SECONDS);
            ret = ret && this.serverConfig.tioExecutor.awaitTermination(6000L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            ret = false;
            Thread.currentThread().interrupt();
            log.error(e.getMessage(), (Throwable)e);
        }
        log.info("{} stopped ret:{}", (Object)this.serverNode, (Object)ret);
        return ret;
    }
}

