/*
 * Decompiled with CFR 0.152.
 */
package org.tio.core.ssl.facade;

import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicLong;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.ChannelContext;
import org.tio.core.ssl.ClientAuth;
import org.tio.core.ssl.SslVo;
import org.tio.core.ssl.facade.Buffers;
import org.tio.core.ssl.facade.Handshaker;
import org.tio.core.ssl.facade.IHandshakeCompletedListener;
import org.tio.core.ssl.facade.ISSLFacade;
import org.tio.core.ssl.facade.ISSLListener;
import org.tio.core.ssl.facade.ISessionClosedListener;
import org.tio.core.ssl.facade.ITaskHandler;
import org.tio.core.ssl.facade.Worker;
import org.tio.utils.buffer.ByteBufferUtil;

public class SSLFacade
implements ISSLFacade {
    private static final Logger log = LoggerFactory.getLogger(SSLFacade.class);
    private final AtomicLong sslSeq = new AtomicLong();
    private final ChannelContext channelContext;
    private final boolean isClientMode;
    private final Worker _worker;
    private final Handshaker _handshaker;
    private IHandshakeCompletedListener _hcl;

    public SSLFacade(ChannelContext channelContext, SSLContext context, boolean client, ClientAuth clientAuth, ITaskHandler taskHandler) {
        this.channelContext = channelContext;
        this.isClientMode = client;
        SSLEngine engine = this.makeSSLEngine(context, client, clientAuth);
        Buffers buffers = new Buffers(engine.getSession());
        this._worker = new Worker(engine, buffers, channelContext);
        this._handshaker = new Handshaker(this._worker, taskHandler, channelContext);
        this._worker.setHandshaker(this._handshaker);
    }

    @Override
    public void beginHandshake() throws SSLException {
        this._handshaker.begin();
    }

    @Override
    public void close() {
        this._worker.close(true);
    }

    @Override
    public void decrypt(ByteBuffer byteBuffer) throws SSLException {
        long seq = this.sslSeq.incrementAndGet();
        if (log.isDebugEnabled()) {
            log.debug("{}, \u51c6\u5907SSL\u89e3\u5bc6:{}, \u5bc6\u6587:{}", new Object[]{this.channelContext, this.channelContext.getId() + " _" + seq, byteBuffer});
        }
        SSLEngineResult result = this._worker.unwrap(byteBuffer);
        if (log.isDebugEnabled()) {
            log.debug("{}, \u5b8c\u6210SSL\u89e3\u5bc6:{}, \u5bc6\u6587:{}, \u7ed3\u679c:{}", new Object[]{this.channelContext, this.channelContext.getId() + " _" + seq, byteBuffer, result});
        }
    }

    @Override
    public void encrypt(SslVo sslVo) throws SSLException {
        long seq = this.sslSeq.incrementAndGet();
        ByteBuffer src = sslVo.getByteBuffer();
        ByteBuffer[] byteBuffers = ByteBufferUtil.split((ByteBuffer)src, (int)Integer.getInteger("tio.ssl.split.unit", 16366));
        if (byteBuffers == null) {
            if (log.isDebugEnabled()) {
                log.debug("{}, \u51c6\u5907SSL\u52a0\u5bc6:{}, \u660e\u6587:{}", new Object[]{this.channelContext, this.channelContext.getId() + " _" + seq, sslVo});
            }
            SSLEngineResult result = this._worker.wrap(sslVo, sslVo.getByteBuffer());
            if (log.isDebugEnabled()) {
                log.debug("{}, \u5b8c\u6210SSL\u52a0\u5bc6:{}, \u660e\u6587:{}, \u7ed3\u679c:{}", new Object[]{this.channelContext, this.channelContext.getId() + " _" + seq, sslVo, result});
            }
        } else {
            if (log.isDebugEnabled()) {
                log.debug("{}, \u51c6\u5907SSL\u52a0\u5bc6:{}, \u5305\u8fc7\u5927\uff0c\u88ab\u62c6\u6210\u4e86[{}]\u4e2a\u5305\u8fdb\u884c\u53d1\u9001, \u660e\u6587:{}", new Object[]{this.channelContext, this.channelContext.getId() + " _" + seq, byteBuffers.length, sslVo});
            }
            ByteBuffer[] encryptedByteBuffers = new ByteBuffer[byteBuffers.length];
            int alllen = 0;
            for (int i = 0; i < byteBuffers.length; ++i) {
                ByteBuffer encryptedByteBuffer;
                SslVo sslVo1 = new SslVo(byteBuffers[i], sslVo.getObj());
                SSLEngineResult result = this._worker.wrap(sslVo1, byteBuffers[i]);
                encryptedByteBuffers[i] = encryptedByteBuffer = sslVo1.getByteBuffer();
                alllen += encryptedByteBuffer.limit();
                if (!log.isDebugEnabled()) continue;
                log.debug("{}, \u5b8c\u6210SSL\u52a0\u5bc6:{}, \u660e\u6587:{}, \u62c6\u5305[{}]\u7684\u7ed3\u679c:{}", new Object[]{this.channelContext, this.channelContext.getId() + " _" + seq, sslVo, i + 1, result});
            }
            ByteBuffer encryptedByteBuffer = ByteBuffer.allocate(alllen);
            for (ByteBuffer byteBuffer : encryptedByteBuffers) {
                encryptedByteBuffer.put(byteBuffer);
            }
            encryptedByteBuffer.flip();
            sslVo.setByteBuffer(encryptedByteBuffer);
        }
    }

    @Override
    public boolean isClientMode() {
        return this.isClientMode;
    }

    @Override
    public boolean isCloseCompleted() {
        return this._worker.isCloseCompleted();
    }

    @Override
    public boolean isHandshakeCompleted() {
        return this._handshaker == null || this._handshaker.isFinished();
    }

    private SSLEngine makeSSLEngine(SSLContext context, boolean client, ClientAuth clientAuth) {
        SSLEngine engine = context.createSSLEngine();
        engine.setUseClientMode(client);
        if (!client) {
            switch (clientAuth) {
                case OPTIONAL: {
                    engine.setWantClientAuth(true);
                    break;
                }
                case REQUIRE: {
                    engine.setNeedClientAuth(true);
                    break;
                }
                case NONE: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown auth " + (Object)((Object)clientAuth));
                }
            }
        }
        return engine;
    }

    @Override
    public void setCloseListener(ISessionClosedListener l) {
        this._worker.setSessionClosedListener(l);
        this._handshaker.setSessionClosedListener(l);
    }

    @Override
    public void setHandshakeCompletedListener(IHandshakeCompletedListener hcl) {
        this._hcl = hcl;
        this.attachCompletionListener();
    }

    @Override
    public void setSSLListener(ISSLListener l) {
        this._worker.setSSLListener(l);
    }

    @Override
    public void terminate() {
        this._worker.close(false);
    }

    private void attachCompletionListener() {
        this._handshaker.addCompletedListener(new IHandshakeCompletedListener(){

            @Override
            public void onComplete() {
                if (SSLFacade.this._hcl != null) {
                    SSLFacade.this._hcl.onComplete();
                    SSLFacade.this._hcl = null;
                }
            }
        });
    }
}

