/*
 * Decompiled with CFR 0.152.
 */
package org.tio.core.ssl.facade;

import java.nio.ByteBuffer;
import java.util.Arrays;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.ChannelContext;
import org.tio.core.ssl.SslVo;
import org.tio.core.ssl.facade.BufferType;
import org.tio.core.ssl.facade.BufferUtils;
import org.tio.core.ssl.facade.Buffers;
import org.tio.core.ssl.facade.Handshaker;
import org.tio.core.ssl.facade.ISSLListener;
import org.tio.core.ssl.facade.ISessionClosedListener;

class Worker {
    private static final Logger log = LoggerFactory.getLogger(Worker.class);
    private final SSLEngine _engine;
    private final Buffers _buffers;
    private final ChannelContext channelContext;
    private ISSLListener _sslListener;
    private ISessionClosedListener _sessionClosedListener;
    private Handshaker handshaker = null;

    Worker(SSLEngine engine, Buffers buffers, ChannelContext channelContext) {
        this._engine = engine;
        this._buffers = buffers;
        this.channelContext = channelContext;
    }

    private static ByteBuffer makeExternalBuffer(ByteBuffer internalBuffer) {
        ByteBuffer newBuffer = ByteBuffer.allocate(internalBuffer.position());
        internalBuffer.flip();
        BufferUtils.copy(internalBuffer, newBuffer);
        return newBuffer;
    }

    void beginHandshake() throws SSLException {
        this._engine.beginHandshake();
    }

    void close(boolean properly) {
        this._engine.closeOutbound();
        try {
            if (properly) {
                this.wrap(new SslVo(), null);
            }
            this._engine.closeInbound();
        }
        catch (SSLException sSLException) {
            // empty catch block
        }
    }

    private SSLEngineResult doUnwrap() throws SSLException {
        ByteBuffer cipherText = this._buffers.get(BufferType.IN_CIPHER);
        ByteBuffer plainText = this._buffers.get(BufferType.IN_PLAIN);
        try {
            if (log.isDebugEnabled()) {
                log.debug("{}, doUnwrap(\u89e3\u5bc6): \u5bc6\u6587buffer:{}, \u660e\u6587buffer: {}", new Object[]{this.channelContext, cipherText, plainText});
            }
            return this._engine.unwrap(cipherText, plainText);
        }
        catch (SSLException e) {
            if (log.isErrorEnabled()) {
                byte[] bs = new byte[cipherText.limit()];
                System.arraycopy(cipherText.array(), 0, bs, 0, bs.length);
                log.error("{} \u89e3\u5bc6Error, byte:{}, string:{}, buffer:{}", new Object[]{this.channelContext, Arrays.toString(bs), new String(bs), cipherText});
            }
            throw e;
        }
    }

    private SSLEngineResult doWrap() throws SSLException {
        ByteBuffer plainText = this._buffers.get(BufferType.OUT_PLAIN);
        ByteBuffer cipherText = this._buffers.get(BufferType.OUT_CIPHER);
        if (log.isDebugEnabled()) {
            log.debug("{}, doWrap(\u52a0\u5bc6): plainText:{} to cipherText: {}", new Object[]{this.channelContext, plainText, cipherText});
        }
        return this._engine.wrap(plainText, cipherText);
    }

    public void emitPlainData(SSLEngineResult result) {
        if (result.bytesProduced() > 0) {
            ByteBuffer internalPlainBuffer = this._buffers.get(BufferType.IN_PLAIN);
            if (log.isDebugEnabled()) {
                log.debug("{} internalPlainBuffer {} ", (Object)this.channelContext, (Object)internalPlainBuffer);
            }
            ByteBuffer plainBuffer = Worker.makeExternalBuffer(internalPlainBuffer);
            if (log.isDebugEnabled()) {
                log.debug("{} plainBuffer[{}][{}] \r\n{}", new Object[]{this.channelContext, result.getHandshakeStatus(), plainBuffer.limit(), plainBuffer.array()});
            }
            if (log.isDebugEnabled()) {
                log.debug("{} emitPlaintData \u63e1\u624b\u72b6\u6001 HandshakeStatus {}", (Object)this.channelContext, (Object)result.getHandshakeStatus());
            }
            this._sslListener.onPlainData(plainBuffer);
        } else if (log.isDebugEnabled()) {
            log.debug("result.bytesProduced() = {} <= 0, result.bytesConsumed() = {}", (Object)result.bytesProduced(), (Object)result.bytesConsumed());
        }
    }

    private void emitWrappedData(SslVo sslVo, SSLEngineResult result) {
        if (result.bytesProduced() > 0) {
            ByteBuffer internalCipherBuffer = this._buffers.get(BufferType.OUT_CIPHER);
            sslVo.setByteBuffer(Worker.makeExternalBuffer(internalCipherBuffer));
            this._sslListener.onWrappedData(sslVo);
        }
    }

    Runnable getDelegatedTask() {
        return this._engine.getDelegatedTask();
    }

    SSLEngineResult.HandshakeStatus getHandshakeStatus() {
        return this._engine.getHandshakeStatus();
    }

    boolean isCloseCompleted() {
        return this._engine.isOutboundDone();
    }

    boolean pendingUnwrap() {
        return !this._buffers.isCacheEmpty();
    }

    void setSessionClosedListener(ISessionClosedListener scl) {
        this._sessionClosedListener = scl;
    }

    void setSSLListener(ISSLListener SSLListener) {
        this._sslListener = SSLListener;
    }

    SSLEngineResult unwrap(ByteBuffer encryptedData) throws SSLException {
        ByteBuffer allEncryptedData = this._buffers.prependCached(encryptedData);
        this._buffers.prepareForUnwrap(allEncryptedData);
        SSLEngineResult result = this.doUnwrap();
        allEncryptedData.position(result.bytesConsumed());
        ByteBuffer unprocessedEncryptedData = BufferUtils.slice(allEncryptedData);
        this.handshaker.handleUnwrapResult(result);
        this.emitPlainData(result);
        switch (result.getStatus()) {
            case BUFFER_UNDERFLOW: {
                this._buffers.cache(unprocessedEncryptedData);
                break;
            }
            case BUFFER_OVERFLOW: {
                this._buffers.grow(BufferType.IN_PLAIN);
                if (unprocessedEncryptedData == null) {
                    throw new RuntimeException("Worker.unwrap had buffer_overflow but all data was consumed!!");
                }
                this.unwrap(unprocessedEncryptedData);
                break;
            }
            case OK: {
                if (unprocessedEncryptedData == null) {
                    this._buffers.clearCache();
                    break;
                }
                this._buffers.cache(unprocessedEncryptedData);
                break;
            }
            case CLOSED: {
                if (this._sessionClosedListener == null) break;
                this._sessionClosedListener.onSessionClosed();
            }
        }
        if (!this._buffers.isCacheEmpty() && result.getStatus() == SSLEngineResult.Status.OK && result.bytesConsumed() > 0) {
            ByteBuffer byteBuffer = ByteBuffer.allocate(0);
            result = this.unwrap(byteBuffer);
        }
        return result;
    }

    SSLEngineResult wrap(SslVo sslVo, ByteBuffer plainData) throws SSLException {
        this._buffers.prepareForWrap(plainData);
        SSLEngineResult result = this.doWrap();
        this.emitWrappedData(sslVo, result);
        switch (result.getStatus()) {
            case BUFFER_UNDERFLOW: {
                throw new RuntimeException("BUFFER_UNDERFLOW while wrapping!");
            }
            case BUFFER_OVERFLOW: {
                this._buffers.grow(BufferType.OUT_CIPHER);
                if (plainData == null || !plainData.hasRemaining()) break;
                plainData.position(result.bytesConsumed());
                ByteBuffer remainingData = BufferUtils.slice(plainData);
                this.wrap(sslVo, remainingData);
                break;
            }
            case OK: {
                break;
            }
            case CLOSED: {
                if (this._sessionClosedListener == null) break;
                this._sessionClosedListener.onSessionClosed();
            }
        }
        return result;
    }

    public void setHandshaker(Handshaker handshaker) {
        this.handshaker = handshaker;
    }
}

