/*
 * Decompiled with CFR 0.152.
 */
package org.tio.core.stat;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class ChannelStat
implements Serializable {
    private static final long serialVersionUID = -6942731710053482089L;
    public final AtomicLong sentBytes = new AtomicLong();
    public final AtomicLong sentPackets = new AtomicLong();
    public final AtomicLong handledBytes = new AtomicLong();
    public final AtomicLong handledPackets = new AtomicLong();
    public final AtomicLong handledPacketCosts = new AtomicLong();
    public final AtomicLong receivedBytes = new AtomicLong();
    public final AtomicLong receivedTcps = new AtomicLong();
    public final AtomicLong receivedPackets = new AtomicLong();
    public final AtomicInteger heartbeatTimeoutCount = new AtomicInteger();
    public int decodeFailCount = 0;
    public long latestTimeOfReceivedPacket;
    public long latestTimeOfSentPacket;
    public long latestTimeOfReceivedByte;
    public long latestTimeOfSentByte;
    public long timeCreated;
    public Long timeFirstConnected = null;
    public long timeClosed;

    public ChannelStat() {
        this(System.currentTimeMillis());
    }

    private ChannelStat(long now) {
        this.latestTimeOfReceivedPacket = now;
        this.latestTimeOfSentPacket = now;
        this.latestTimeOfReceivedByte = now;
        this.latestTimeOfSentByte = now;
        this.timeCreated = now;
        this.timeClosed = now;
    }

    public double getBytesPerTcpReceive() {
        if (this.receivedTcps.get() == 0L) {
            return 0.0;
        }
        return this.receivedBytes.doubleValue() / this.receivedTcps.doubleValue();
    }

    public double getPacketsPerTcpReceive() {
        if (this.receivedTcps.get() == 0L) {
            return 0.0;
        }
        return this.receivedPackets.doubleValue() / this.receivedTcps.doubleValue();
    }

    public int getDecodeFailCount() {
        return this.decodeFailCount;
    }

    public AtomicLong getHandledBytes() {
        return this.handledBytes;
    }

    public AtomicLong getHandledPackets() {
        return this.handledPackets;
    }

    public long getLatestTimeOfReceivedPacket() {
        return this.latestTimeOfReceivedPacket;
    }

    public long getLatestTimeOfSentPacket() {
        return this.latestTimeOfSentPacket;
    }

    public void setLatestTimeOfSentPacket(long latestTimeOfSentPacket) {
        this.latestTimeOfSentPacket = latestTimeOfSentPacket;
    }

    public AtomicLong getReceivedBytes() {
        return this.receivedBytes;
    }

    public AtomicLong getReceivedPackets() {
        return this.receivedPackets;
    }

    public AtomicLong getSentBytes() {
        return this.sentBytes;
    }

    public AtomicLong getSentPackets() {
        return this.sentPackets;
    }

    public long getTimeClosed() {
        return this.timeClosed;
    }

    public void setTimeClosed(long timeClosed) {
        this.timeClosed = timeClosed;
    }

    public long getTimeCreated() {
        return this.timeCreated;
    }

    public Long getTimeFirstConnected() {
        return this.timeFirstConnected;
    }

    public void setTimeFirstConnected(Long timeFirstConnected) {
        this.timeFirstConnected = timeFirstConnected;
    }

    public long getLatestTimeOfReceivedByte() {
        return this.latestTimeOfReceivedByte;
    }

    public void setLatestTimeOfReceivedByte(long latestTimeOfReceivedByte) {
        this.latestTimeOfReceivedByte = latestTimeOfReceivedByte;
    }

    public long getLatestTimeOfSentByte() {
        return this.latestTimeOfSentByte;
    }

    public void setLatestTimeOfSentByte(long latestTimeOfSentByte) {
        this.latestTimeOfSentByte = latestTimeOfSentByte;
    }

    public AtomicLong getReceivedTcps() {
        return this.receivedTcps;
    }

    public AtomicLong getHandledPacketCosts() {
        return this.handledPacketCosts;
    }

    public double getHandledCostsPerPacket() {
        if (this.handledPackets.get() > 0L) {
            return this.handledPacketCosts.doubleValue() / this.handledPackets.doubleValue();
        }
        return 0.0;
    }
}

