/*
 * Decompiled with CFR 0.152.
 */
package org.tio.server.proxy;

public class ProxyProtocolMessage {
    private final String protocol;
    private final String sourceAddress;
    private final String destinationAddress;
    private final int sourcePort;
    private final int destinationPort;

    public ProxyProtocolMessage(String protocol, String sourceAddress, String destinationAddress, String sourcePort, String destinationPort) {
        this(protocol, sourceAddress, destinationAddress, ProxyProtocolMessage.portStringToInt(sourcePort), ProxyProtocolMessage.portStringToInt(destinationPort));
    }

    public ProxyProtocolMessage(String protocol, String sourceAddress, String destinationAddress, int sourcePort, int destinationPort) {
        this.protocol = protocol;
        this.sourceAddress = sourceAddress;
        this.destinationAddress = destinationAddress;
        this.sourcePort = sourcePort;
        this.destinationPort = destinationPort;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getSourceAddress() {
        return this.sourceAddress;
    }

    public String getDestinationAddress() {
        return this.destinationAddress;
    }

    public int getSourcePort() {
        return this.sourcePort;
    }

    public int getDestinationPort() {
        return this.destinationPort;
    }

    private static int portStringToInt(String value) {
        int port;
        try {
            port = Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("invalid port: " + value, e);
        }
        if (port <= 0 || port > 65535) {
            throw new IllegalArgumentException("invalid port: " + value + " (expected: 1 ~ 65535)");
        }
        return port;
    }

    public String toString() {
        return "ProxyProtocolMessage{protocol='" + this.protocol + '\'' + ", sourceAddress='" + this.sourceAddress + '\'' + ", destinationAddress='" + this.destinationAddress + '\'' + ", sourcePort=" + this.sourcePort + ", destinationPort=" + this.destinationPort + '}';
    }
}

