/*
 * Decompiled with CFR 0.152.
 */
package org.tio.utils;

import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.tio.utils.thread.pool.DefaultThreadFactory;
import org.tio.utils.thread.pool.SynThreadPoolExecutor;
import org.tio.utils.thread.pool.TioCallerRunsPolicy;

public class Threads {
    public static final int AVAILABLE_PROCESSORS;
    public static final int CORE_POOL_SIZE;
    public static final int MAX_POOL_SIZE_FOR_TIO;
    public static final int MAX_POOL_SIZE_FOR_GROUP;
    public static final long KEEP_ALIVE_TIME = 0L;
    private static ThreadPoolExecutor groupExecutor;
    private static SynThreadPoolExecutor tioExecutor;

    private Threads() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ThreadPoolExecutor getGroupExecutor() {
        if (groupExecutor != null) {
            return groupExecutor;
        }
        Class<Threads> clazz = Threads.class;
        synchronized (Threads.class) {
            if (groupExecutor != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return groupExecutor;
            }
            LinkedBlockingQueue<Runnable> runnableQueue = new LinkedBlockingQueue<Runnable>();
            DefaultThreadFactory threadFactory = DefaultThreadFactory.getInstance("tio-group", 10);
            TioCallerRunsPolicy callerRunsPolicy = new TioCallerRunsPolicy();
            groupExecutor = new ThreadPoolExecutor(MAX_POOL_SIZE_FOR_GROUP, MAX_POOL_SIZE_FOR_GROUP, 0L, TimeUnit.SECONDS, runnableQueue, threadFactory, callerRunsPolicy);
            groupExecutor.prestartCoreThread();
            // ** MonitorExit[var0] (shouldn't be in output)
            return groupExecutor;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SynThreadPoolExecutor getTioExecutor() {
        if (tioExecutor != null) {
            return tioExecutor;
        }
        Class<Threads> clazz = Threads.class;
        synchronized (Threads.class) {
            if (tioExecutor != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return tioExecutor;
            }
            LinkedBlockingQueue<Runnable> runnableQueue = new LinkedBlockingQueue<Runnable>();
            DefaultThreadFactory defaultThreadFactory = DefaultThreadFactory.getInstance("tio-worker", 10);
            TioCallerRunsPolicy callerRunsPolicy = new TioCallerRunsPolicy();
            tioExecutor = new SynThreadPoolExecutor(MAX_POOL_SIZE_FOR_TIO, MAX_POOL_SIZE_FOR_TIO, 0L, runnableQueue, defaultThreadFactory, (RejectedExecutionHandler)callerRunsPolicy);
            tioExecutor.prestartCoreThread();
            // ** MonitorExit[var0] (shouldn't be in output)
            return tioExecutor;
        }
    }

    public static String stackTrace() {
        StackTraceElement[] elements = Thread.currentThread().getStackTrace();
        StringBuilder buf = new StringBuilder();
        for (StackTraceElement element : elements) {
            buf.append("\r\n\t").append(element.getClassName()).append('.').append(element.getMethodName()).append('(').append(element.getFileName()).append(':').append(element.getLineNumber()).append(')');
        }
        return buf.toString();
    }

    static {
        CORE_POOL_SIZE = AVAILABLE_PROCESSORS = Runtime.getRuntime().availableProcessors();
        MAX_POOL_SIZE_FOR_TIO = Integer.getInteger("TIO_MAX_POOL_SIZE_FOR_TIO", Math.max(CORE_POOL_SIZE * 2, 8));
        MAX_POOL_SIZE_FOR_GROUP = Integer.getInteger("TIO_MAX_POOL_SIZE_FOR_GROUP", Math.max(CORE_POOL_SIZE * 4, 16));
        groupExecutor = null;
        tioExecutor = null;
    }
}

