/*
 * Decompiled with CFR 0.152.
 */
package org.tio.utils.buffer;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.tio.utils.mica.HexUtils;

public class ByteBufferUtil {
    public static final byte[] EMPTY_BYTES = new byte[0];

    public static byte readByte(ByteBuffer buffer) {
        return buffer.get();
    }

    public static short readUnsignedByte(ByteBuffer buffer) {
        return (short)(buffer.get() & 0xFF);
    }

    public static String readString(ByteBuffer buffer, int count) {
        return ByteBufferUtil.readString(buffer, count, StandardCharsets.UTF_8);
    }

    public static String readString(ByteBuffer buffer, int count, Charset charset) {
        byte[] bytes = new byte[count];
        buffer.get(bytes);
        return new String(bytes, charset);
    }

    public static int readUnsignedShort(ByteBuffer buffer) {
        int ch1 = buffer.get() & 0xFF;
        int ch2 = buffer.get() & 0xFF;
        return (ch1 << 8) + ch2;
    }

    public static ByteBuffer skipBytes(ByteBuffer buffer, int skip) {
        buffer.position(buffer.position() + skip);
        return buffer;
    }

    public static String toString(ByteBuffer buffer) {
        return ByteBufferUtil.toString(buffer, StandardCharsets.UTF_8);
    }

    public static String toString(ByteBuffer buffer, Charset charset) {
        return new String(buffer.array(), buffer.position(), buffer.limit(), charset);
    }

    public static ByteBuffer clone(ByteBuffer original) {
        ByteBuffer clone = ByteBuffer.allocate(original.capacity());
        original.rewind();
        clone.put(original);
        original.rewind();
        clone.flip();
        return clone;
    }

    public static String hexDump(ByteBuffer byteBuffer) {
        byte[] bytes = new byte[byteBuffer.remaining()];
        byteBuffer.get(bytes);
        return ByteBufferUtil.toHexString(bytes);
    }

    public static String toHexString(byte[] bytes) {
        int i;
        StringBuilder buffer = new StringBuilder(bytes.length);
        buffer.append("\r\n\t\t   0  1  2  3  4  5  6  7  8  9  a  b  c  d  e  f\r\n");
        int startIndex = 0;
        int column = 0;
        block4: for (i = 0; i < bytes.length; ++i) {
            column = i % 16;
            switch (column) {
                case 0: {
                    startIndex = i;
                    buffer.append(ByteBufferUtil.fixHexString(Integer.toHexString(i))).append(": ");
                    buffer.append(HexUtils.encode(bytes[i]));
                    buffer.append(' ');
                    continue block4;
                }
                case 15: {
                    buffer.append(HexUtils.encode(bytes[i]));
                    buffer.append(" ; ");
                    buffer.append(ByteBufferUtil.filterString(bytes, startIndex, column + 1));
                    buffer.append("\r\n");
                    continue block4;
                }
                default: {
                    buffer.append(HexUtils.encode(bytes[i]));
                    buffer.append(' ');
                }
            }
        }
        if (column != 15) {
            for (i = 0; i < 15 - column; ++i) {
                buffer.append("   ");
            }
            buffer.append("; ").append(ByteBufferUtil.filterString(bytes, startIndex, column + 1));
            buffer.append("\r\n");
        }
        return buffer.toString();
    }

    private static String filterString(byte[] bytes, int offset, int count) {
        byte[] buffer = new byte[count];
        System.arraycopy(bytes, offset, buffer, 0, count);
        for (int i = 0; i < count; ++i) {
            if (buffer[i] < 0 || buffer[i] > 31) continue;
            buffer[i] = 46;
        }
        return new String(buffer);
    }

    private static String fixHexString(String hexStr) {
        if (hexStr == null || hexStr.length() == 0) {
            return "00000000h";
        }
        StringBuilder buf = new StringBuilder(8);
        int strLen = hexStr.length();
        for (int i = 0; i < 8 - strLen; ++i) {
            buf.append('0');
        }
        buf.append(hexStr).append('h');
        return buf.toString();
    }
}

