/*
 * Decompiled with CFR 0.152.
 */
package org.tio.utils.json;

import java.util.List;
import org.tio.utils.hutool.ClassUtil;
import org.tio.utils.json.FastJson1JsonAdapter;
import org.tio.utils.json.FastJson2JsonAdapter;
import org.tio.utils.json.GsonJsonAdapter;
import org.tio.utils.json.HuToolJsonAdapter;
import org.tio.utils.json.JacksonJsonAdapter;
import org.tio.utils.json.JsonAdapter;

public class JsonUtil {
    private static JsonAdapter jsonAdapter;

    public static JsonAdapter getJsonAdapter() {
        return jsonAdapter == null ? JsonUtil.getJsonAdapter(null) : jsonAdapter;
    }

    public static JsonAdapter getJsonAdapter(JsonAdapter jsonAdapter) {
        JsonAdapter defaultJsonAdapter;
        if (jsonAdapter != null) {
            defaultJsonAdapter = jsonAdapter;
        } else if (ClassUtil.isPresent("com.fasterxml.jackson.databind.ObjectMapper")) {
            defaultJsonAdapter = new JacksonJsonAdapter();
        } else if (ClassUtil.isPresent("com.alibaba.fastjson2.JSON")) {
            defaultJsonAdapter = new FastJson2JsonAdapter();
        } else if (ClassUtil.isPresent("com.google.gson.Gson")) {
            defaultJsonAdapter = new GsonJsonAdapter();
        } else if (ClassUtil.isPresent("com.alibaba.fastjson.JSON")) {
            defaultJsonAdapter = new FastJson1JsonAdapter();
        } else if (ClassUtil.isPresent("cn.hutool.json.JSONUtil")) {
            defaultJsonAdapter = new HuToolJsonAdapter();
        } else {
            throw new IllegalArgumentException("Args jsonAdapter is null and there is no available JSON toolkits (Jackson, Fastjson1, Fastjson2, Gson, Hutool-json)");
        }
        JsonUtil.jsonAdapter = defaultJsonAdapter;
        return defaultJsonAdapter;
    }

    public static String toJsonString(Object object) {
        return JsonUtil.getJsonAdapter().toJsonString(object);
    }

    public static <T> T readValue(String json, Class<T> clazz) {
        return JsonUtil.getJsonAdapter().readValue(json, clazz);
    }

    public static <T> List<T> readList(String json, Class<T> clazz) {
        return JsonUtil.getJsonAdapter().readList(json, clazz);
    }
}

