/*
 * Decompiled with CFR 0.152.
 */
package org.tio.utils.timer;

import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.Function;
import org.tio.utils.timer.Timer;
import org.tio.utils.timer.TimerTask;
import org.tio.utils.timer.TimerTaskEntry;

class TimerTaskList
implements Delayed {
    private final LongAdder taskCounter;
    private final TimerTaskEntry root;
    private final AtomicLong expiration;

    public TimerTaskList(LongAdder taskCounter) {
        this.taskCounter = taskCounter;
        this.root.next = this.root = new TimerTaskEntry(null, -1L);
        this.root.prev = this.root;
        this.expiration = new AtomicLong(-1L);
    }

    public boolean setExpiration(Long expirationMs) {
        return this.expiration.getAndSet(expirationMs) != expirationMs.longValue();
    }

    public long getExpiration() {
        return this.expiration.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void foreach(Function<TimerTask, Void> f) {
        TimerTaskList timerTaskList = this;
        synchronized (timerTaskList) {
            TimerTaskEntry entry = this.root.next;
            while (entry != this.root) {
                TimerTaskEntry nextEntry = entry.next;
                if (!entry.cancelled()) {
                    f.apply(entry.getTimerTask());
                }
                entry = nextEntry;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(TimerTaskEntry timerTaskEntry) {
        boolean done = false;
        while (!done) {
            timerTaskEntry.remove();
            TimerTaskList timerTaskList = this;
            synchronized (timerTaskList) {
                if (timerTaskEntry.getList() == null) {
                    TimerTaskEntry tail = this.root.prev;
                    timerTaskEntry.next = this.root;
                    timerTaskEntry.prev = tail;
                    timerTaskEntry.setList(this);
                    tail.next = timerTaskEntry;
                    this.root.prev = timerTaskEntry;
                    this.taskCounter.increment();
                    done = true;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(TimerTaskEntry timerTaskEntry) {
        TimerTaskList timerTaskList = this;
        synchronized (timerTaskList) {
            if (timerTaskEntry.getList() == this) {
                timerTaskEntry.next.prev = timerTaskEntry.prev;
                timerTaskEntry.prev.next = timerTaskEntry.next;
                timerTaskEntry.next = null;
                timerTaskEntry.prev = null;
                timerTaskEntry.setList(null);
                this.taskCounter.decrement();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush(Function<TimerTaskEntry, Void> f) {
        TimerTaskList timerTaskList = this;
        synchronized (timerTaskList) {
            TimerTaskEntry head = this.root.next;
            while (head != this.root) {
                this.remove(head);
                f.apply(head);
                head = this.root.next;
            }
            this.expiration.set(-1L);
        }
    }

    @Override
    public long getDelay(TimeUnit unit) {
        return unit.convert(Long.max(this.getExpiration() - Timer.getHiresClockMs(), 0L), TimeUnit.MILLISECONDS);
    }

    @Override
    public int compareTo(Delayed delayed) {
        if (delayed instanceof TimerTaskList) {
            return Long.compare(this.getExpiration(), ((TimerTaskList)delayed).getExpiration());
        }
        throw new ClassCastException("can not cast to TimerTaskList");
    }
}

