/*
 * Decompiled with CFR 0.152.
 */
package org.tio.utils.thread.pool;

import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSynRunnable
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(AbstractSynRunnable.class);
    public final Executor executor;
    public boolean executed = false;
    protected ReentrantLock runningLock = new ReentrantLock();
    private boolean isCanceled = false;

    protected AbstractSynRunnable(Executor executor) {
        this.executor = executor;
    }

    public void execute() {
        this.executor.execute(this);
    }

    public abstract boolean isNeededExecute();

    public boolean isCanceled() {
        return this.isCanceled;
    }

    public void setCanceled(boolean isCanceled) {
        this.isCanceled = isCanceled;
    }

    @Override
    public final void run() {
        if (this.isCanceled()) {
            return;
        }
        boolean tryLock = false;
        try {
            tryLock = this.runningLock.tryLock(1L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e1) {
            log.error(e1.getMessage(), (Throwable)e1);
        }
        if (tryLock) {
            try {
                int loopCount = 0;
                this.runTask();
                while (this.isNeededExecute() && loopCount++ < 100) {
                    this.runTask();
                }
            }
            catch (Throwable e) {
                log.error(e.getMessage(), e);
            }
            finally {
                this.executed = false;
                this.runningLock.unlock();
            }
        } else {
            this.executed = false;
        }
        if (this.isNeededExecute()) {
            this.execute();
        }
    }

    public abstract void runTask();

    public String logstr() {
        return this.getClass().getName();
    }
}

