/*
 * Decompiled with CFR 0.152.
 */
package org.tio.utils.cache;

import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import org.tio.utils.cache.AbstractCache;
import org.tio.utils.cache.CacheObj;

public abstract class ReentrantCache<K extends Serializable, V extends Serializable>
extends AbstractCache<K, V> {
    private static final long serialVersionUID = 1L;
    protected final ReentrantLock lock = new ReentrantLock();

    ReentrantCache(Map<K, CacheObj<K, V>> cacheMap, int capacity, long timeout) {
        super(cacheMap, capacity, timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(K key, V object, long timeout) {
        this.lock.lock();
        try {
            this.putWithoutLock(key, object, timeout);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKey(K key) {
        this.lock.lock();
        try {
            CacheObj co = this.getWithoutLock(key);
            if (co == null) {
                boolean bl = false;
                return bl;
            }
            if (!co.isExpired()) {
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this.lock.unlock();
        }
        this.remove(key, true);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(K key, boolean isUpdateLastAccess) {
        CacheObj co;
        this.lock.lock();
        try {
            co = this.getWithoutLock(key);
        }
        finally {
            this.lock.unlock();
        }
        if (null == co) {
            this.missCount.increment();
            return null;
        }
        if (!co.isExpired()) {
            this.hitCount.increment();
            return co.get(isUpdateLastAccess);
        }
        this.remove(key, true);
        return null;
    }

    @Override
    public final int prune() {
        this.lock.lock();
        try {
            int n = this.pruneCache();
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void remove(K key) {
        this.remove(key, false);
    }

    @Override
    public void clear() {
        this.lock.lock();
        try {
            super.clear();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public String toString() {
        this.lock.lock();
        try {
            String string = super.toString();
            return string;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void remove(K key, boolean withMissCount) {
        CacheObj co;
        this.lock.lock();
        try {
            co = this.removeWithoutLock(key, withMissCount);
        }
        finally {
            this.lock.unlock();
        }
        if (null != co) {
            this.onRemove(co.key, co.obj);
        }
    }
}

