/*
 * Decompiled with CFR 0.152.
 */
package org.tio.utils.json;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.CollectionType;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.tio.utils.json.JsonAdapter;
import org.tio.utils.mica.ExceptionUtils;

public class JacksonJsonAdapter
implements JsonAdapter {
    public static final String CLAZZ_NAME = "com.fasterxml.jackson.databind.ObjectMapper";
    private final ObjectMapper objectMapper;

    public JacksonJsonAdapter() {
        this(new ObjectMapper());
    }

    public JacksonJsonAdapter(ObjectMapper objectMapper) {
        this.objectMapper = Objects.requireNonNull(objectMapper, "objectMapper is null.");
    }

    @Override
    public String toJsonString(Object object) {
        try {
            return this.objectMapper.writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            throw ExceptionUtils.unchecked(e);
        }
    }

    @Override
    public byte[] toJsonBytes(Object object) {
        try {
            return this.objectMapper.writeValueAsBytes(object);
        }
        catch (JsonProcessingException e) {
            throw ExceptionUtils.unchecked(e);
        }
    }

    @Override
    public <T> T readValue(String json, Class<T> clazz) {
        try {
            return (T)this.objectMapper.readValue(json, clazz);
        }
        catch (JsonProcessingException e) {
            throw ExceptionUtils.unchecked(e);
        }
    }

    @Override
    public <T> T readValue(byte[] json, Class<T> clazz) {
        try {
            return (T)this.objectMapper.readValue(json, clazz);
        }
        catch (IOException e) {
            throw ExceptionUtils.unchecked(e);
        }
    }

    @Override
    public <T> List<T> readList(String json, Class<T> clazz) {
        CollectionType javaType = this.objectMapper.getTypeFactory().constructCollectionType(List.class, clazz);
        try {
            return (List)this.objectMapper.readValue(json, (JavaType)javaType);
        }
        catch (JsonProcessingException e) {
            throw ExceptionUtils.unchecked(e);
        }
    }

    @Override
    public <T> List<T> readList(byte[] json, Class<T> clazz) {
        CollectionType javaType = this.objectMapper.getTypeFactory().constructCollectionType(List.class, clazz);
        try {
            return (List)this.objectMapper.readValue(json, (JavaType)javaType);
        }
        catch (IOException e) {
            throw ExceptionUtils.unchecked(e);
        }
    }
}

