/*
 * Decompiled with CFR 0.152.
 */
package org.tio.utils.queue;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.utils.queue.DataFile;
import org.tio.utils.queue.Mapped;
import org.tio.utils.queue.OffsetFile;
import org.tio.utils.queue.Writer;

final class Reader<E>
extends Mapped {
    private static final Logger log = LoggerFactory.getLogger(Reader.class);
    static final String NAME = "data.read";
    private final BlockingQueue<Path> clearQueue = new LinkedBlockingQueue<Path>(12);
    private final Path path;
    private final long mfs;
    private final long mds;
    Writer<E> writer;
    long dataIdx;
    private OffsetFile offset;
    private long offsetIdx;
    private long offsetName;
    private DataFile data;
    private long dataName;
    private long maxDataIdx;
    private long maxOffsetIdx;
    private final ReentrantLock lock = new ReentrantLock();

    public Reader(Path path, long mfs, long mds, Writer<E> writer) throws IOException {
        super(path.resolve(NAME), 0L, 8L);
        this.path = path;
        this.mfs = mfs;
        this.mds = mds;
        this.writer = writer;
        this.dataIdx = this.readCurrentDataIndex();
        this.offset = this.initOffsetMapped();
        this.offsetIdx = this.readCurrentOffsetIndex();
        this.data = this.initDataMapped();
        this.maxDataIdx = this.readMaxDataIndex();
        this.startCleanThread();
    }

    public E take(Function<byte[], E> mapper) throws InterruptedException {
        E poll;
        while ((poll = this.poll(mapper)) == null) {
            while (this.offsetIdx >= this.writer.offsetIdx) {
                this.writer.waiting();
            }
        }
        return poll;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public E poll(Function<byte[], E> mapper) {
        this.lock.lock();
        try {
            byte[] bytes = this.poll0();
            if (bytes == null) {
                E e = null;
                return e;
            }
            ++this.dataIdx;
            this.buffer.putLong(this.dataIdx);
            this.buffer.flip();
            E e = mapper.apply(bytes);
            return e;
        }
        finally {
            this.lock.unlock();
        }
    }

    private byte[] poll0() {
        int len;
        long cur;
        if (this.offset == null) {
            return null;
        }
        if (this.offsetIdx >= this.writer.offsetIdx) {
            return null;
        }
        if (this.dataIdx >= this.maxDataIdx) {
            this.nextOffset();
        }
        if ((cur = this.offset.read()) > this.maxOffsetIdx) {
            this.nextData();
        }
        if ((long)(len = (int)(cur - this.offsetIdx)) > this.mds) {
            throw new RuntimeException("\u6570\u636e\u8d85\u957f\uff01 \u6700\u5927\u957f\u5ea6\uff1a" + this.mds + ", \u5f53\u524d\u957f\u5ea6: " + len);
        }
        byte[] buf = new byte[len];
        this.data.read(buf, len);
        this.offsetIdx += (long)len;
        return buf;
    }

    private void nextData() {
        try {
            Path nextFile = Reader.pathname(this.path, this.offsetIdx, ".data");
            this.data.close();
            this.maxOffsetIdx = this.offsetIdx + this.mfs;
            this.data = new DataFile(nextFile, 0L, this.mfs);
            this.clearQueue.put(Reader.pathname(this.path, this.dataName, ".data"));
            this.dataName = this.offsetIdx;
            log.debug("\u8bfb\u53d6\u4e0b\u4e00\u4e2a\u6570\u636e\u6587\u4ef6: {}", (Object)nextFile);
        }
        catch (Exception e) {
            throw new RuntimeException("\u521b\u5efa\u8bfb\u53d6\u65e5\u5fd7\u6587\u4ef6\u6620\u5c04\u5730\u5740\u5f02\u5e38", e);
        }
    }

    private void nextOffset() {
        try {
            Path nextFile = Reader.pathname(this.path, this.dataIdx, ".offset");
            if (Files.notExists(nextFile, new LinkOption[0])) {
                throw new RuntimeException("\u6587\u4ef6\u4e0d\u5b58\u5728\uff01- " + nextFile);
            }
            this.offset.close();
            this.maxDataIdx += this.mfs / 8L;
            this.offset = new OffsetFile(nextFile, 0L, this.mfs);
            this.clearQueue.put(Reader.pathname(this.path, this.offsetName, ".offset"));
            this.offsetName = this.dataIdx;
            log.debug("\u8bfb\u53d6\u4e0b\u4e00\u4e2a\u504f\u79fb\u91cf\u6587\u4ef6:{}", (Object)nextFile);
        }
        catch (Exception e) {
            throw new RuntimeException("\u521b\u5efa\u6570\u636e\u504f\u79fb\u91cf\u6587\u4ef6\u6620\u5c04\u5730\u5740\u5f02\u5e38", e);
        }
    }

    private DataFile initDataMapped() throws IOException {
        this.dataName = DataFile.name(this.path, this.offsetIdx, this.mfs);
        if (this.dataName < 0L || this.offsetIdx - this.dataName > this.mfs) {
            throw new RuntimeException("\u6587\u4ef6\u504f\u79fb\u91cf\u5f02\u5e38, \u83b7\u53d6\u7684\u6570\u636e\u6587\u4ef6: " + this.dataName + ", \u5f53\u524d\u9700\u8981\u5199\u5165\u7684\u504f\u79fb\u91cf: " + this.offsetIdx);
        }
        Path pathname = Reader.pathname(this.path, this.dataName, ".data");
        if (this.dataIdx != 0L && Files.notExists(pathname, new LinkOption[0])) {
            throw new RuntimeException("\u6587\u4ef6\u4e0d\u5b58\u5728\uff01" + pathname);
        }
        this.maxOffsetIdx = this.dataName + this.mfs;
        return new DataFile(pathname, this.offsetIdx - this.dataName, this.dataName + this.mfs - this.offsetIdx);
    }

    private long readCurrentOffsetIndex() throws IOException {
        if (this.dataIdx == 0L) {
            return 0L;
        }
        long pos = this.dataIdx * 8L % this.mfs - 8L;
        if (this.dataIdx * 8L % this.mfs == 0L) {
            pos = this.mfs - 8L;
        }
        return this.offset.get(pos, 8);
    }

    private OffsetFile initOffsetMapped() throws IOException {
        long name = 0L;
        if (this.dataIdx != 0L && this.dataIdx % (this.mfs / 8L) == 0L) {
            name = this.dataIdx - this.mfs / 8L;
        } else if (this.dataIdx % (this.mfs / 8L) != 0L) {
            name = this.dataIdx - this.dataIdx % (this.mfs / 8L);
        }
        Path pathname = Reader.pathname(this.path, name, ".offset");
        if (this.dataIdx != 0L && Files.notExists(pathname, new LinkOption[0])) {
            throw new RuntimeException("\u7a0b\u5e8f\u6709\u8bef,\u9700\u8981\u8bfb\u7684\u6587\u4ef6\u627e\u4e0d\u5230,\u6587\u4ef6\u540d:" + pathname);
        }
        this.offsetName = name;
        if (this.dataIdx != 0L && this.dataIdx * 8L % this.mfs == 0L) {
            return new OffsetFile(pathname, this.mfs, 0L);
        }
        return new OffsetFile(pathname, this.dataIdx * 8L % this.mfs, this.mfs - this.dataIdx * 8L % this.mfs);
    }

    private long readCurrentDataIndex() {
        long idx;
        if (this.newed) {
            idx = this.writer.dataIdx;
            this.buffer.putLong(idx);
            log.debug("\u9996\u6b21\u8bfb\u53d6:{}", (Object)this.path);
        } else {
            idx = this.buffer.getLong();
            log.debug("\u7ee7\u7eed\u8bfb\u53d6:{}", (Object)this.path);
        }
        this.buffer.flip();
        return idx;
    }

    private long readMaxDataIndex() {
        return (this.dataIdx == 0L || this.dataIdx % (this.mfs / 8L) != 0L ? this.dataIdx / (this.mfs / 8L) + 1L : this.dataIdx / (this.mfs / 8L)) * (this.mfs / 8L);
    }

    private void startCleanThread() {
        Thread thread = new Thread(() -> {
            try {
                while (true) {
                    Path consumed = this.clearQueue.take();
                    Files.deleteIfExists(consumed);
                    log.debug("\u5df2\u8bfb\u5e76\u5220\u9664\uff1a{}", (Object)consumed);
                }
            }
            catch (IOException | InterruptedException e) {
                log.error(e.getMessage(), (Throwable)e);
                return;
            }
        });
        thread.setDaemon(true);
        thread.setName("FileQueueClear");
        thread.start();
    }

    @Override
    public void close() throws IOException {
        this.lock.lock();
        try {
            super.close();
            this.data.close();
            this.data = null;
            this.offset.close();
            this.offset = null;
        }
        finally {
            this.lock.unlock();
        }
    }
}

