/*
 * Decompiled with CFR 0.152.
 */
package org.tio.utils.timer;

import java.util.function.Function;
import org.tio.utils.timer.SystemTimer;
import org.tio.utils.timer.TimerTask;
import org.tio.utils.timer.TimerTaskService;
import org.tio.utils.timer.TimingWheelThread;

public class DefaultTimerTaskService
implements TimerTaskService {
    private final SystemTimer systemTimer;
    private final TimingWheelThread timingWheelThread;

    public DefaultTimerTaskService() {
        this(1000L, 60);
    }

    public DefaultTimerTaskService(long tickMs, int wheelSize) {
        this(new SystemTimer(tickMs, wheelSize, "DefaultTimerTaskService"));
    }

    public DefaultTimerTaskService(SystemTimer systemTimer) {
        this(systemTimer, new TimingWheelThread(systemTimer));
    }

    public DefaultTimerTaskService(SystemTimer systemTimer, TimingWheelThread timingWheelThread) {
        this.systemTimer = systemTimer;
        this.timingWheelThread = timingWheelThread;
    }

    @Override
    public <T extends TimerTask> T addTask(Function<SystemTimer, T> consumer) {
        TimerTask timerTask = (TimerTask)consumer.apply(this.systemTimer);
        this.systemTimer.add(timerTask);
        return (T)timerTask;
    }

    @Override
    public void start() {
        if (!this.timingWheelThread.isStarted()) {
            this.timingWheelThread.start();
        }
    }

    @Override
    public void stop() {
        this.timingWheelThread.shutdown();
        this.systemTimer.shutdown();
    }
}

