/*
 * Decompiled with CFR 0.152.
 */
package org.tio.utils.buffer;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.tio.utils.mica.HexUtils;

public class ByteBufferUtil {
    public static final byte[] EMPTY_BYTES = new byte[0];

    private ByteBufferUtil() {
    }

    public static byte readByte(ByteBuffer buffer) {
        return buffer.get();
    }

    public static short readUnsignedByte(ByteBuffer buffer) {
        return (short)(buffer.get() & 0xFF);
    }

    public static byte[] readBytes(ByteBuffer buffer, int length) {
        byte[] data = new byte[length];
        buffer.get(data, 0, length);
        return data;
    }

    public static short readShort(ByteBuffer buffer) {
        return buffer.getShort();
    }

    public static short readShortLE(ByteBuffer buffer) {
        byte[] value = new byte[2];
        buffer.get(value, 0, 2);
        short ret = value[0];
        ret = (short)(ret | (short)((value[1] & 0xFF) << 8));
        return ret;
    }

    public static short readShortBE(ByteBuffer buffer) {
        byte[] value = new byte[2];
        buffer.get(value, 0, 2);
        short ret = (short)(value[0] << 8);
        ret = (short)(ret | (short)(value[1] & 0xFF));
        return ret;
    }

    public static int readUnsignedShort(ByteBuffer buffer) {
        ByteOrder order = buffer.order();
        if (ByteOrder.BIG_ENDIAN == order) {
            return ByteBufferUtil.readUnsignedShortBE(buffer);
        }
        return ByteBufferUtil.readUnsignedShortLE(buffer);
    }

    public static int readUnsignedShortLE(ByteBuffer buffer) {
        byte[] value = new byte[2];
        buffer.get(value, 0, 2);
        int ret = value[0] & 0xFF;
        return ret |= (value[1] & 0xFF) << 8;
    }

    public static int readUnsignedShortBE(ByteBuffer buffer) {
        byte[] value = new byte[2];
        buffer.get(value, 0, 2);
        int ret = (value[0] & 0xFF) << 8;
        return ret |= value[1] & 0xFF;
    }

    public static int readMedium(ByteBuffer buffer) {
        ByteOrder order = buffer.order();
        if (ByteOrder.BIG_ENDIAN == order) {
            return ByteBufferUtil.readMediumBE(buffer);
        }
        return ByteBufferUtil.readMediumLE(buffer);
    }

    public static int readMediumLE(ByteBuffer buffer) {
        int ret = ByteBufferUtil.readUnsignedMediumLE(buffer);
        if ((ret & 0x800000) != 0) {
            ret |= 0xFF000000;
        }
        return ret;
    }

    public static int readMediumBE(ByteBuffer buffer) {
        int ret = ByteBufferUtil.readUnsignedMediumBE(buffer);
        if ((ret & 0x800000) != 0) {
            ret |= 0xFF000000;
        }
        return ret;
    }

    public static int readUnsignedMedium(ByteBuffer buffer) {
        ByteOrder order = buffer.order();
        if (ByteOrder.BIG_ENDIAN == order) {
            return ByteBufferUtil.readUnsignedMediumBE(buffer);
        }
        return ByteBufferUtil.readUnsignedMediumLE(buffer);
    }

    public static int readUnsignedMediumLE(ByteBuffer buffer) {
        byte[] value = new byte[3];
        buffer.get(value, 0, 3);
        int ret = value[0] & 0xFF;
        ret |= (value[1] & 0xFF) << 8;
        return ret |= (value[2] & 0xFF) << 16;
    }

    public static int readUnsignedMediumBE(ByteBuffer buffer) {
        byte[] value = new byte[3];
        buffer.get(value, 0, 3);
        int ret = (value[0] & 0xFF) << 16;
        ret |= (value[1] & 0xFF) << 8;
        return ret |= value[2] & 0xFF;
    }

    public static int readInt(ByteBuffer buffer) {
        return buffer.getInt();
    }

    public static int readIntLE(ByteBuffer buffer) {
        byte[] value = new byte[4];
        buffer.get(value, 0, 4);
        int ret = value[0] & 0xFF;
        ret |= (value[1] & 0xFF) << 8;
        ret |= (value[2] & 0xFF) << 16;
        return ret |= value[3] << 24;
    }

    public static int readIntBE(ByteBuffer buffer) {
        byte[] value = new byte[4];
        buffer.get(value, 0, 4);
        int ret = value[0] << 24;
        ret |= (value[1] & 0xFF) << 16;
        ret |= (value[2] & 0xFF) << 8;
        return ret |= value[3] & 0xFF;
    }

    public static long readUnsignedInt(ByteBuffer buffer) {
        ByteOrder order = buffer.order();
        if (ByteOrder.BIG_ENDIAN == order) {
            return ByteBufferUtil.readUnsignedIntBE(buffer);
        }
        return ByteBufferUtil.readUnsignedIntLE(buffer);
    }

    public static long readUnsignedIntLE(ByteBuffer buffer) {
        byte[] value = new byte[4];
        buffer.get(value, 0, 4);
        long ret = value[0] & 0xFF;
        ret |= (long)((value[1] & 0xFF) << 8);
        ret |= (long)((value[2] & 0xFF) << 16);
        return ret |= (long)(value[3] & 0xFF) << 24;
    }

    public static long readUnsignedIntBE(ByteBuffer buffer) {
        byte[] value = new byte[4];
        buffer.get(value, 0, 4);
        long ret = (long)(value[0] & 0xFF) << 24;
        ret |= (long)((value[1] & 0xFF) << 16);
        ret |= (long)((value[2] & 0xFF) << 8);
        return ret |= (long)(value[3] & 0xFF);
    }

    public static float readFloat(ByteBuffer buffer) {
        return buffer.getFloat();
    }

    public static float readFloatLE(ByteBuffer buffer) {
        return Float.intBitsToFloat(ByteBufferUtil.readIntLE(buffer));
    }

    public static float readFloatBE(ByteBuffer buffer) {
        return Float.intBitsToFloat(ByteBufferUtil.readIntBE(buffer));
    }

    public static long readLong(ByteBuffer buffer) {
        return buffer.getLong();
    }

    public static long readLongLE(ByteBuffer buffer) {
        byte[] value = new byte[8];
        buffer.get(value, 0, 8);
        long ret = value[0] & 0xFF;
        ret |= (long)((value[1] & 0xFF) << 8);
        ret |= (long)((value[2] & 0xFF) << 16);
        ret |= (long)(value[3] & 0xFF) << 24;
        ret |= (long)(value[4] & 0xFF) << 32;
        ret |= (long)(value[5] & 0xFF) << 40;
        ret |= (long)(value[6] & 0xFF) << 48;
        return ret |= (long)value[7] << 56;
    }

    public static long readLongBE(ByteBuffer buffer) {
        byte[] value = new byte[8];
        buffer.get(value, 0, 8);
        long ret = (long)value[0] << 56;
        ret |= (long)(value[1] & 0xFF) << 48;
        ret |= (long)(value[2] & 0xFF) << 40;
        ret |= (long)(value[3] & 0xFF) << 32;
        ret |= (long)(value[4] & 0xFF) << 24;
        ret |= (long)((value[5] & 0xFF) << 16);
        ret |= (long)((value[6] & 0xFF) << 8);
        return ret |= (long)(value[7] & 0xFF);
    }

    public static long readUnsignedLong(ByteBuffer buffer) {
        ByteOrder order = buffer.order();
        if (ByteOrder.BIG_ENDIAN == order) {
            return ByteBufferUtil.readUnsignedLongBE(buffer);
        }
        return ByteBufferUtil.readUnsignedLongLE(buffer);
    }

    public static long readUnsignedLongLE(ByteBuffer buffer) {
        byte[] value = new byte[8];
        buffer.get(value, 0, 8);
        long ret = value[0] & 0xFF;
        ret |= (long)((value[1] & 0xFF) << 8);
        ret |= (long)((value[2] & 0xFF) << 16);
        ret |= (long)(value[3] & 0xFF) << 24;
        ret |= (long)(value[4] & 0xFF) << 32;
        ret |= (long)(value[5] & 0xFF) << 40;
        ret |= (long)(value[6] & 0xFF) << 48;
        return ret |= (long)(value[7] & 0xFF) << 56;
    }

    public static long readUnsignedLongBE(ByteBuffer buffer) {
        byte[] value = new byte[8];
        buffer.get(value, 0, 8);
        long ret = (long)(value[0] & 0xFF) << 56;
        ret |= (long)(value[1] & 0xFF) << 48;
        ret |= (long)(value[2] & 0xFF) << 40;
        ret |= (long)(value[3] & 0xFF) << 32;
        ret |= (long)(value[4] & 0xFF) << 24;
        ret |= (long)((value[5] & 0xFF) << 16);
        ret |= (long)((value[6] & 0xFF) << 8);
        return ret |= (long)(value[7] & 0xFF);
    }

    public static double readDouble(ByteBuffer buffer) {
        return buffer.getDouble();
    }

    public static double readDoubleLE(ByteBuffer buffer) {
        return Double.longBitsToDouble(ByteBufferUtil.readLongLE(buffer));
    }

    public static double readDoubleBE(ByteBuffer buffer) {
        return Double.longBitsToDouble(ByteBufferUtil.readLongBE(buffer));
    }

    public static void writeUnsignedByte(ByteBuffer buffer, short s) {
        buffer.put((byte)s);
    }

    public static void writeShortLE(ByteBuffer buffer, short s) {
        byte[] value = new byte[]{(byte)s, (byte)(s >> 8)};
        buffer.put(value, 0, 2);
    }

    public static void writeShortBE(ByteBuffer buffer, short s) {
        byte[] value = new byte[]{(byte)(s >> 8), (byte)s};
        buffer.put(value, 0, 2);
    }

    public static void writeUnsignedShortLE(ByteBuffer buffer, int i) {
        byte[] value = new byte[]{(byte)(i & 0xFF), (byte)(i >>> 8)};
        buffer.put(value, 0, 2);
    }

    public static void writeUnsignedShortBE(ByteBuffer buffer, int i) {
        byte[] value = new byte[]{(byte)(i >>> 8), (byte)(i & 0xFF)};
        buffer.put(value, 0, 2);
    }

    public static void writeUnsignedMediumLE(ByteBuffer buffer, int i) {
        byte[] value = new byte[]{(byte)(i & 0xFF), (byte)(i >>> 8), (byte)(i >>> 16)};
        buffer.put(value, 0, 3);
    }

    public static void writeUnsignedMediumBE(ByteBuffer buffer, int i) {
        byte[] value = new byte[]{(byte)(i >>> 16), (byte)(i >>> 8), (byte)(i & 0xFF)};
        buffer.put(value, 0, 3);
    }

    public static void writeIntLE(ByteBuffer buffer, int i) {
        byte[] value = new byte[]{(byte)i, (byte)(i >> 8), (byte)(i >> 16), (byte)(i >> 24)};
        buffer.put(value, 0, 4);
    }

    public static void writeIntBE(ByteBuffer buffer, int i) {
        byte[] value = new byte[]{(byte)(i >> 24), (byte)(i >> 16), (byte)(i >> 8), (byte)i};
        buffer.put(value, 0, 4);
    }

    public static void writeUnsignedIntLE(ByteBuffer buffer, long l) {
        byte[] value = new byte[]{(byte)(l & 0xFFL), (byte)(l >>> 8), (byte)(l >>> 16), (byte)(l >>> 24)};
        buffer.put(value, 0, 4);
    }

    public static void writeUnsignedIntBE(ByteBuffer buffer, long l) {
        byte[] value = new byte[]{(byte)(l >>> 24), (byte)(l >>> 16), (byte)(l >>> 8), (byte)(l & 0xFFL)};
        buffer.put(value, 0, 4);
    }

    public static void writeFloat(ByteBuffer buffer, float value) {
        buffer.putFloat(value);
    }

    public static void writeFloatLE(ByteBuffer buffer, float value) {
        ByteBufferUtil.writeIntLE(buffer, Float.floatToRawIntBits(value));
    }

    public static void writeFloatBE(ByteBuffer buffer, float value) {
        ByteBufferUtil.writeIntBE(buffer, Float.floatToRawIntBits(value));
    }

    public static void writeLongLE(ByteBuffer buffer, long l) {
        byte[] value = new byte[]{(byte)l, (byte)(l >> 8), (byte)(l >> 16), (byte)(l >> 24), (byte)(l >> 32), (byte)(l >> 40), (byte)(l >> 48), (byte)(l >> 56)};
        buffer.put(value, 0, 8);
    }

    public static void writeLongBE(ByteBuffer buffer, long l) {
        byte[] value = new byte[]{(byte)(l >> 56), (byte)(l >> 48), (byte)(l >> 40), (byte)(l >> 32), (byte)(l >> 24), (byte)(l >> 16), (byte)(l >> 8), (byte)l};
        buffer.put(value, 0, 8);
    }

    public static void writeUnsignedLongLE(ByteBuffer buffer, long l) {
        byte[] value = new byte[]{(byte)(l & 0xFFL), (byte)(l >>> 8), (byte)(l >>> 16), (byte)(l >>> 24), (byte)(l >>> 32), (byte)(l >>> 40), (byte)(l >>> 48), (byte)(l >>> 56)};
        buffer.put(value, 0, 8);
    }

    public static void writeUnsignedLongBE(ByteBuffer buffer, long l) {
        byte[] value = new byte[]{(byte)(l >>> 56), (byte)(l >>> 48), (byte)(l >>> 40), (byte)(l >>> 32), (byte)(l >>> 24), (byte)(l >>> 16), (byte)(l >>> 8), (byte)(l & 0xFFL)};
        buffer.put(value, 0, 8);
    }

    public static void writeDouble(ByteBuffer buffer, double value) {
        buffer.putDouble(value);
    }

    public static void writeDoubleLE(ByteBuffer buffer, double value) {
        ByteBufferUtil.writeLongLE(buffer, Double.doubleToRawLongBits(value));
    }

    public static void writeDoubleBE(ByteBuffer buffer, double value) {
        ByteBufferUtil.writeLongBE(buffer, Double.doubleToRawLongBits(value));
    }

    public static ByteBuffer skipBytes(ByteBuffer buffer, int skip) {
        buffer.position(buffer.position() + skip);
        return buffer;
    }

    public static ByteBuffer composite(ByteBuffer byteBuffer1, ByteBuffer byteBuffer2) {
        int capacity = byteBuffer1.remaining() + byteBuffer2.remaining();
        ByteBuffer ret = ByteBuffer.allocate(capacity);
        ret.put(byteBuffer1);
        ret.put(byteBuffer2);
        ret.position(0);
        ret.limit(ret.capacity());
        return ret;
    }

    public static ByteBuffer clone(ByteBuffer original) {
        ByteBuffer clone = ByteBuffer.allocate(original.capacity());
        original.rewind();
        clone.put(original);
        original.rewind();
        clone.flip();
        return clone;
    }

    public static void copy(ByteBuffer src, int srcStartIndex, ByteBuffer dest, int destStartIndex, int length) {
        System.arraycopy(src.array(), srcStartIndex, dest.array(), destStartIndex, length);
    }

    public static ByteBuffer copy(ByteBuffer src, int startIndex, int endIndex) {
        int size = endIndex - startIndex;
        int initPosition = src.position();
        int initLimit = src.limit();
        src.position(startIndex);
        src.limit(endIndex);
        ByteBuffer ret = ByteBuffer.allocate(size);
        ret.put(src);
        ret.flip();
        src.position(initPosition);
        src.limit(initLimit);
        return ret;
    }

    public static ByteBuffer copy(ByteBuffer src) {
        int startIndex = src.position();
        int endIndex = src.limit();
        return ByteBufferUtil.copy(src, startIndex, endIndex);
    }

    public static ByteBuffer[] split(ByteBuffer src, int unitSize) {
        int limit = src.limit();
        if (unitSize >= limit) {
            return null;
        }
        int size = (int)Math.ceil((double)src.limit() / (double)unitSize);
        ByteBuffer[] ret = new ByteBuffer[size];
        int srcIndex = 0;
        for (int i = 0; i < size; ++i) {
            int bufferSize = unitSize;
            if (i == size - 1) {
                bufferSize = src.limit() % unitSize;
            }
            byte[] dest = new byte[bufferSize];
            System.arraycopy(src.array(), srcIndex, dest, 0, dest.length);
            srcIndex += bufferSize;
            ret[i] = ByteBuffer.wrap(dest);
            ret[i].position(0);
            ret[i].limit(ret[i].capacity());
        }
        return ret;
    }

    public static int lineEnd(ByteBuffer buffer) {
        return ByteBufferUtil.lineEnd(buffer, Integer.MAX_VALUE);
    }

    public static int lineEnd(ByteBuffer buffer, int maxLength) {
        int initPosition = buffer.position();
        int endPosition = ByteBufferUtil.indexOf(buffer, '\n', maxLength);
        if (endPosition - initPosition > 0 && buffer.get(endPosition - 1) == 13) {
            return endPosition - 1;
        }
        return endPosition;
    }

    public static int indexOf(ByteBuffer buffer, char theChar, int maxLength) {
        boolean needJudgeLengthOverflow;
        int count = 0;
        boolean bl = needJudgeLengthOverflow = buffer.remaining() > maxLength;
        while (buffer.hasRemaining()) {
            if (buffer.get() == theChar) {
                return buffer.position() - 1;
            }
            if (!needJudgeLengthOverflow || ++count <= maxLength) continue;
            throw new IndexOutOfBoundsException("maxlength is " + maxLength);
        }
        return -1;
    }

    public static String readLine(ByteBuffer buffer, Charset charset) {
        return ByteBufferUtil.readLine(buffer, charset, Integer.MAX_VALUE);
    }

    public static String readLine(ByteBuffer buffer, Charset charset, int maxLength) {
        int startPosition = buffer.position();
        int endPosition = ByteBufferUtil.lineEnd(buffer, maxLength);
        if (endPosition == -1) {
            return null;
        }
        int nowPosition = buffer.position();
        if (endPosition > startPosition) {
            byte[] bs = new byte[endPosition - startPosition];
            buffer.position(startPosition);
            buffer.get(bs);
            buffer.position(nowPosition);
            if (charset == null) {
                return new String(bs);
            }
            return new String(bs, charset);
        }
        if (endPosition == startPosition) {
            return "";
        }
        return null;
    }

    public static String readString(ByteBuffer buffer, int count) {
        return ByteBufferUtil.readString(buffer, count, StandardCharsets.UTF_8);
    }

    public static String readString(ByteBuffer buffer, int count, Charset charset) {
        byte[] bytes = new byte[count];
        buffer.get(bytes);
        return new String(bytes, charset);
    }

    public static String readString(ByteBuffer buffer, Charset charset, char endChar, int maxLength) {
        int startPosition = buffer.position();
        int endPosition = ByteBufferUtil.indexOf(buffer, endChar, maxLength);
        if (endPosition == -1) {
            return null;
        }
        int nowPosition = buffer.position();
        if (endPosition > startPosition) {
            byte[] bs = new byte[endPosition - startPosition];
            buffer.position(startPosition);
            buffer.get(bs);
            buffer.position(nowPosition);
            if (charset == null) {
                return new String(bs);
            }
            return new String(bs, charset);
        }
        if (endPosition == startPosition) {
            return "";
        }
        return null;
    }

    public static String toString(ByteBuffer buffer) {
        return ByteBufferUtil.toString(buffer, StandardCharsets.UTF_8);
    }

    public static String toString(ByteBuffer buffer, Charset charset) {
        return new String(buffer.array(), charset);
    }

    public static String toString(byte[] buffer) {
        return ByteBufferUtil.toString(buffer, StandardCharsets.UTF_8);
    }

    public static String toString(byte[] buffer, Charset charset) {
        return new String(buffer, charset);
    }

    public static String hexDump(ByteBuffer byteBuffer) {
        byte[] data = Arrays.copyOf(byteBuffer.array(), byteBuffer.remaining());
        return ByteBufferUtil.toHexString(data);
    }

    public static String toHexString(byte[] bytes) {
        int i;
        StringBuilder buffer = new StringBuilder(bytes.length);
        buffer.append("\r\n\t\t   0  1  2  3  4  5  6  7  8  9  a  b  c  d  e  f\r\n");
        int startIndex = 0;
        int column = 0;
        block4: for (i = 0; i < bytes.length; ++i) {
            column = i % 16;
            switch (column) {
                case 0: {
                    startIndex = i;
                    buffer.append(ByteBufferUtil.fixHexString(Integer.toHexString(i))).append(": ");
                    buffer.append(HexUtils.encode(bytes[i]));
                    buffer.append(' ');
                    continue block4;
                }
                case 15: {
                    buffer.append(HexUtils.encode(bytes[i]));
                    buffer.append(" ; ");
                    buffer.append(ByteBufferUtil.filterString(bytes, startIndex, column + 1));
                    buffer.append("\r\n");
                    continue block4;
                }
                default: {
                    buffer.append(HexUtils.encode(bytes[i]));
                    buffer.append(' ');
                }
            }
        }
        if (column != 15) {
            for (i = 0; i < 15 - column; ++i) {
                buffer.append("   ");
            }
            buffer.append("; ").append(ByteBufferUtil.filterString(bytes, startIndex, column + 1));
            buffer.append("\r\n");
        }
        return buffer.toString();
    }

    private static String filterString(byte[] bytes, int offset, int count) {
        byte[] buffer = new byte[count];
        System.arraycopy(bytes, offset, buffer, 0, count);
        for (int i = 0; i < count; ++i) {
            if (buffer[i] < 0 || buffer[i] > 31) continue;
            buffer[i] = 46;
        }
        return new String(buffer);
    }

    private static String fixHexString(String hexStr) {
        if (hexStr == null || hexStr.isEmpty()) {
            return "00000000h";
        }
        StringBuilder buf = new StringBuilder(8);
        int strLen = hexStr.length();
        for (int i = 0; i < 8 - strLen; ++i) {
            buf.append('0');
        }
        buf.append(hexStr).append('h');
        return buf.toString();
    }
}

