/*
 * Decompiled with CFR 0.152.
 */
package org.tio.utils.queue;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Comparator;
import org.tio.utils.queue.Mapped;

final class DataFile
extends Mapped {
    static final File[] EMPTY_FILES = new File[0];
    static final String EXTENSION = ".data";

    DataFile(Path path, long pos, long size) throws IOException {
        super(path, pos, size);
    }

    void write(byte[] bytes) {
        this.buffer.put(bytes);
    }

    void read(byte[] dst, int len) {
        this.buffer.get(dst, 0, len);
    }

    private static long fmtName(File file) {
        return Long.parseLong(file.getName().substring(0, 19));
    }

    private static File[] files(Path path) {
        File[] files = path.toFile().listFiles((dir, name) -> name.endsWith(EXTENSION));
        if (files == null || files.length == 0) {
            return EMPTY_FILES;
        }
        Arrays.sort(files, Comparator.comparingLong(DataFile::fmtName));
        return files;
    }

    public static long name(Path path, long offset, long maxFileSize) {
        File[] files = DataFile.files(path);
        if (files.length == 0) {
            return 0L;
        }
        for (File file : files) {
            long format = DataFile.fmtName(file);
            if (format == offset) {
                return format;
            }
            if (format >= offset || format < offset - maxFileSize) continue;
            return format;
        }
        return -1L;
    }
}

