/*
 * Decompiled with CFR 0.152.
 */
package org.tio.utils.page;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import org.tio.utils.page.Page;

public class PageUtils {
    public static <T> Page<T> fromList(List<T> list, int pageNumber, int pageSize) {
        return PageUtils.fromList(list, pageNumber, pageSize, null);
    }

    public static <E, T> Page<T> fromList(List<E> list, int pageNumber, int pageSize, Function<E, T> converter) {
        if (list == null) {
            return null;
        }
        Page<T> page = PageUtils.pre(list, pageNumber, pageSize);
        List<T> pageData = page.getList();
        if (pageData == null) {
            return page;
        }
        int startIndex = Math.min((page.getPageNumber() - 1) * page.getPageSize(), list.size());
        int endIndex = Math.min(page.getPageNumber() * page.getPageSize(), list.size());
        for (int i = startIndex; i < endIndex; ++i) {
            if (converter != null) {
                pageData.add(converter.apply(list.get(i)));
                continue;
            }
            pageData.add(list.get(i));
        }
        page.setList(pageData);
        return page;
    }

    public static <T> Page<T> fromSet(Set<T> set, int pageNumber, int pageSize) {
        return PageUtils.fromSet(set, pageNumber, pageSize, null, null);
    }

    public static <E, T> Page<T> fromSet(Set<E> set, int pageNumber, int pageSize, Function<E, T> converter) {
        return PageUtils.fromSet(set, pageNumber, pageSize, null, converter);
    }

    public static <E, T> Page<T> fromSet(Set<E> set, int pageNumber, int pageSize, Predicate<E> filter, Function<E, T> converter) {
        if (set == null) {
            return null;
        }
        Page<T> page = PageUtils.pre(set, pageNumber, pageSize);
        List<T> pageData = page.getList();
        if (pageData == null) {
            return page;
        }
        int startIndex = Math.min((page.getPageNumber() - 1) * page.getPageSize(), set.size());
        int endIndex = Math.min(page.getPageNumber() * page.getPageSize(), set.size());
        int i = 0;
        for (E e : set) {
            if (i >= endIndex) break;
            if (i < startIndex || filter != null && !filter.test(e)) {
                ++i;
                continue;
            }
            if (converter != null) {
                pageData.add(converter.apply(e));
            } else {
                pageData.add(e);
            }
            ++i;
        }
        page.setList(pageData);
        return page;
    }

    private static <E, T> Page<T> pre(Collection<E> allList, int pageNumber, int pageSize) {
        if (allList == null) {
            return new Page(null, pageNumber, pageSize, 0);
        }
        pageSize = PageUtils.processPageSize(pageSize);
        pageNumber = PageUtils.processPageNumber(pageNumber);
        int recordCount = allList.size();
        if (pageSize > recordCount) {
            pageSize = recordCount;
        }
        ArrayList pageData = new ArrayList(pageSize);
        return new Page(pageData, pageNumber, pageSize, recordCount);
    }

    private static int processPageNumber(int pageNumber) {
        return pageNumber <= 0 ? 1 : pageNumber;
    }

    private static int processPageSize(int pageSize) {
        return pageSize <= 0 ? Integer.MAX_VALUE : pageSize;
    }
}

