/*
 * Decompiled with CFR 0.152.
 */
package org.tio.utils.cache;

import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.tio.utils.cache.CacheObj;
import org.tio.utils.cache.ReentrantCache;

public class FIFOCache<K extends Serializable, V extends Serializable>
extends ReentrantCache<K, V> {
    private static final long serialVersionUID = 1L;

    public FIFOCache(int capacity) {
        this(capacity, 0L);
    }

    public FIFOCache(int capacity, long timeout) {
        super(FIFOCache.getCacheMap(capacity), capacity, timeout);
    }

    private static <K extends Serializable, V extends Serializable> Map<K, CacheObj<K, V>> getCacheMap(int capacity) {
        return new LinkedHashMap(capacity + 1, 1.0f, false);
    }

    @Override
    protected int pruneCache() {
        int count = 0;
        CacheObj first = null;
        Iterator values = this.cacheObjIter();
        if (this.isPruneExpiredActive()) {
            while (values.hasNext()) {
                CacheObj co = values.next();
                if (co.isExpired()) {
                    values.remove();
                    this.onRemove(co.key, co.obj);
                    ++count;
                    continue;
                }
                if (first != null) continue;
                first = co;
            }
        } else {
            CacheObj cacheObj = first = values.hasNext() ? values.next() : null;
        }
        if (this.isFull() && null != first) {
            this.removeWithoutLock(first.key);
            this.onRemove(first.key, first.obj);
            ++count;
        }
        return count;
    }
}

