/*
 * Decompiled with CFR 0.152.
 */
package org.tio.utils.compression;

import org.tio.utils.compression.Compression;
import org.tio.utils.hutool.ZipUtil;

public class GzipCompression
implements Compression {
    private final int bufferSize;

    public GzipCompression() {
        this(4096);
    }

    public GzipCompression(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    @Override
    public byte[] compress(byte[] buffer) {
        return ZipUtil.gzip(buffer);
    }

    @Override
    public byte[] decompress(byte[] buffer) {
        return ZipUtil.unGzip(buffer, this.bufferSize);
    }
}

