/*
 * Decompiled with CFR 0.152.
 */
package org.tio.utils.hutool;

import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import org.tio.utils.hutool.FastByteArrayOutputStream;
import org.tio.utils.hutool.StrUtil;

public class ResourceUtil {
    private static final String CLASSPATH_PRE = "classpath:";

    public static String getAbsolutePath(String path) {
        return ResourceUtil.getDecodedPath(ResourceUtil.getResource(path));
    }

    public static URL getResource(String path) {
        if (StrUtil.startWithIgnoreCase(path, CLASSPATH_PRE)) {
            path = path.substring(CLASSPATH_PRE.length());
        }
        return ResourceUtil.getClassLoader().getResource(path);
    }

    public static InputStream getResourceAsStream(String path) {
        if (StrUtil.startWithIgnoreCase(path, CLASSPATH_PRE)) {
            path = path.substring(CLASSPATH_PRE.length());
        }
        return ResourceUtil.getClassLoader().getResourceAsStream(path);
    }

    public static InputStream getFileResource(String file) {
        try {
            return Files.newInputStream(Paths.get(file, new String[0]), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static String getResourceAsText(String path) {
        InputStream stream = ResourceUtil.getResourceAsStream(path);
        if (stream == null) {
            return null;
        }
        return ResourceUtil.streamToString(stream);
    }

    public static String getFileResourceAsText(String file) {
        return ResourceUtil.streamToString(ResourceUtil.getFileResource(file));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String streamToString(InputStream inputStream) {
        try (FastByteArrayOutputStream result = new FastByteArrayOutputStream();){
            int length;
            byte[] buffer = new byte[4096];
            while ((length = inputStream.read(buffer)) != -1) {
                result.write(buffer, 0, length);
            }
            String string = result.toString(StandardCharsets.UTF_8);
            return string;
        }
        catch (Exception e) {
            return null;
        }
    }

    private static ClassLoader getClassLoader() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null && null == (classLoader = ResourceUtil.class.getClassLoader())) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        return classLoader;
    }

    private static String getDecodedPath(URL url) {
        if (null == url) {
            return null;
        }
        String path = null;
        try {
            path = url.toURI().getPath();
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return null != path ? path : url.getPath();
    }
}

