/*
 * Decompiled with CFR 0.152.
 */
package org.tio.utils.page;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;

public class Page<T>
implements Serializable {
    private static final long serialVersionUID = 6551482606063638959L;
    private List<T> list = null;
    private Integer pageNumber;
    private Integer pageSize;
    private Integer totalRow;
    private Integer totalPage;

    public Page() {
    }

    public Page(List<T> list, Integer pageNumber, Integer pageSize, Integer totalRow) {
        this.list = list;
        this.pageNumber = pageNumber;
        this.pageSize = pageSize;
        this.totalRow = totalRow;
    }

    public Page(List<?> list, Integer pageNumber, Integer pageSize, Integer totalRow, Function<Object, T> converter) {
        if (list != null && !list.isEmpty() && converter != null) {
            this.list = new ArrayList<T>(list.size());
            for (Object object : list) {
                T t = converter.apply(object);
                this.list.add(t);
            }
        }
        this.pageNumber = pageNumber;
        this.pageSize = pageSize;
        this.totalRow = totalRow;
    }

    public List<T> getList() {
        return this.list;
    }

    public void setList(List<T> list) {
        this.list = list;
    }

    public Integer getPageNumber() {
        return this.pageNumber;
    }

    public void setPageNumber(Integer pageNumber) {
        this.pageNumber = pageNumber;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public Integer getTotalRow() {
        return this.totalRow;
    }

    public void setTotalRow(Integer totalRow) {
        this.totalRow = totalRow;
    }

    public Integer getTotalPage() {
        double result = Math.ceil((double)this.totalRow.intValue() / (double)this.pageSize.intValue());
        this.totalPage = (int)result;
        return this.totalPage;
    }

    public void setTotalPage(Integer totalPage) {
        this.totalPage = totalPage;
    }

    public boolean isFirstPage() {
        return this.pageNumber <= 1;
    }

    public boolean isLastPage() {
        return this.pageNumber >= this.getTotalPage();
    }

    public String toString() {
        return "Page{list=" + this.list + ", pageNumber=" + this.pageNumber + ", pageSize=" + this.pageSize + ", totalRow=" + this.totalRow + ", totalPage=" + this.getTotalPage() + '}';
    }
}

