/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.mica.swagger.config;

import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.info.Info;
import java.util.Optional;
import net.dreamlu.mica.swagger.config.MicaSwaggerProperties;
import net.dreamlu.mica.swagger.config.SwaggerCustomizer;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.core.env.Environment;

@AutoConfiguration
@ConditionalOnClass(value={OpenAPI.class})
@EnableConfigurationProperties(value={MicaSwaggerProperties.class})
public class SwaggerConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={OpenAPI.class})
    public OpenAPI openAPI(Environment environment, MicaSwaggerProperties properties, ObjectProvider<SwaggerCustomizer> customizerObjectProvider) {
        String appName = environment.getProperty("spring.application.name");
        String defaultName = (appName == null ? "" : appName) + "\u670d\u52a1";
        String title = Optional.ofNullable(properties.getTitle()).orElse(defaultName);
        String description = Optional.ofNullable(properties.getDescription()).orElse(defaultName);
        OpenAPI openAPI = new OpenAPI().info(new Info().title(title).description(description).version(properties.getVersion()).license(properties.getLicense())).externalDocs(properties.getExternalDocumentation());
        customizerObjectProvider.orderedStream().forEach(customizer -> customizer.customize(openAPI));
        return openAPI;
    }
}

