/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.mica.lock.client;

import java.util.concurrent.TimeUnit;
import net.dreamlu.mica.core.function.CheckedSupplier;
import net.dreamlu.mica.core.utils.Exceptions;
import net.dreamlu.mica.lock.annotation.LockType;
import net.dreamlu.mica.lock.client.RedisLockClient;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedisLockClientImpl
implements RedisLockClient {
    private static final Logger log = LoggerFactory.getLogger(RedisLockClientImpl.class);
    private final RedissonClient redissonClient;

    @Override
    public boolean tryLock(String lockName, LockType lockType, long waitTime, long leaseTime, TimeUnit timeUnit) throws InterruptedException {
        RLock lock = this.getLock(lockName, lockType);
        return lock.tryLock(waitTime, leaseTime, timeUnit);
    }

    @Override
    public void unLock(String lockName, LockType lockType) {
        RLock lock = this.getLock(lockName, lockType);
        lock.unlock();
    }

    private RLock getLock(String lockName, LockType lockType) {
        RLock lock = LockType.REENTRANT == lockType ? this.redissonClient.getLock(lockName) : this.redissonClient.getFairLock(lockName);
        return lock;
    }

    @Override
    public <T> T lock(String lockName, LockType lockType, long waitTime, long leaseTime, TimeUnit timeUnit, CheckedSupplier<T> supplier) {
        try {
            boolean result = this.tryLock(lockName, lockType, waitTime, leaseTime, timeUnit);
            if (result) {
                Object object = supplier.get();
                return (T)object;
            }
        }
        catch (Throwable e) {
            throw Exceptions.unchecked((Throwable)e);
        }
        finally {
            this.unLock(lockName, lockType);
        }
        return null;
    }

    public RedisLockClientImpl(RedissonClient redissonClient) {
        this.redissonClient = redissonClient;
    }
}

