/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.mica.lock.config;

import net.dreamlu.mica.core.utils.StringUtil;
import net.dreamlu.mica.lock.client.RedisLockClient;
import net.dreamlu.mica.lock.client.RedisLockClientImpl;
import net.dreamlu.mica.lock.config.MicaLockProperties;
import net.dreamlu.mica.lock.config.RedisLockAspect;
import org.redisson.Redisson;
import org.redisson.api.RedissonClient;
import org.redisson.config.ClusterServersConfig;
import org.redisson.config.Config;
import org.redisson.config.MasterSlaveServersConfig;
import org.redisson.config.SentinelServersConfig;
import org.redisson.config.SingleServerConfig;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={RedissonClient.class})
@EnableConfigurationProperties(value={MicaLockProperties.class})
public class MicaLockAutoConfiguration {
    private static Config singleConfig(MicaLockProperties properties) {
        Config config = new Config();
        SingleServerConfig serversConfig = config.useSingleServer();
        serversConfig.setAddress(properties.getAddress());
        String password = properties.getPassword();
        if (StringUtil.isNotBlank((CharSequence)password)) {
            serversConfig.setPassword(password);
        }
        serversConfig.setDatabase(properties.getDatabase().intValue());
        serversConfig.setConnectionPoolSize(properties.getPoolSize().intValue());
        serversConfig.setConnectionMinimumIdleSize(properties.getIdleSize().intValue());
        serversConfig.setIdleConnectionTimeout(properties.getConnectionTimeout().intValue());
        serversConfig.setConnectTimeout(properties.getConnectionTimeout().intValue());
        serversConfig.setTimeout(properties.getTimeout().intValue());
        return config;
    }

    private static Config masterSlaveConfig(MicaLockProperties properties) {
        Config config = new Config();
        MasterSlaveServersConfig serversConfig = config.useMasterSlaveServers();
        serversConfig.setMasterAddress(properties.getMasterAddress());
        serversConfig.addSlaveAddress(properties.getSlaveAddress());
        String password = properties.getPassword();
        if (StringUtil.isNotBlank((CharSequence)password)) {
            serversConfig.setPassword(password);
        }
        serversConfig.setDatabase(properties.getDatabase().intValue());
        serversConfig.setMasterConnectionPoolSize(properties.getPoolSize().intValue());
        serversConfig.setMasterConnectionMinimumIdleSize(properties.getIdleSize().intValue());
        serversConfig.setSlaveConnectionPoolSize(properties.getPoolSize().intValue());
        serversConfig.setSlaveConnectionMinimumIdleSize(properties.getIdleSize().intValue());
        serversConfig.setIdleConnectionTimeout(properties.getConnectionTimeout().intValue());
        serversConfig.setConnectTimeout(properties.getConnectionTimeout().intValue());
        serversConfig.setTimeout(properties.getTimeout().intValue());
        return config;
    }

    private static Config sentinelConfig(MicaLockProperties properties) {
        Config config = new Config();
        SentinelServersConfig serversConfig = config.useSentinelServers();
        serversConfig.setMasterName(properties.getMasterName());
        serversConfig.addSentinelAddress(properties.getSentinelAddress());
        String password = properties.getPassword();
        if (StringUtil.isNotBlank((CharSequence)password)) {
            serversConfig.setPassword(password);
        }
        serversConfig.setDatabase(properties.getDatabase().intValue());
        serversConfig.setMasterConnectionPoolSize(properties.getPoolSize().intValue());
        serversConfig.setMasterConnectionMinimumIdleSize(properties.getIdleSize().intValue());
        serversConfig.setSlaveConnectionPoolSize(properties.getPoolSize().intValue());
        serversConfig.setSlaveConnectionMinimumIdleSize(properties.getIdleSize().intValue());
        serversConfig.setIdleConnectionTimeout(properties.getConnectionTimeout().intValue());
        serversConfig.setConnectTimeout(properties.getConnectionTimeout().intValue());
        serversConfig.setTimeout(properties.getTimeout().intValue());
        return config;
    }

    private static Config clusterConfig(MicaLockProperties properties) {
        Config config = new Config();
        ClusterServersConfig serversConfig = config.useClusterServers();
        serversConfig.addNodeAddress(properties.getNodeAddress());
        String password = properties.getPassword();
        if (StringUtil.isNotBlank((CharSequence)password)) {
            serversConfig.setPassword(password);
        }
        serversConfig.setMasterConnectionPoolSize(properties.getPoolSize().intValue());
        serversConfig.setMasterConnectionMinimumIdleSize(properties.getIdleSize().intValue());
        serversConfig.setSlaveConnectionPoolSize(properties.getPoolSize().intValue());
        serversConfig.setSlaveConnectionMinimumIdleSize(properties.getIdleSize().intValue());
        serversConfig.setIdleConnectionTimeout(properties.getConnectionTimeout().intValue());
        serversConfig.setConnectTimeout(properties.getConnectionTimeout().intValue());
        serversConfig.setTimeout(properties.getTimeout().intValue());
        return config;
    }

    @Bean
    @ConditionalOnMissingBean
    public RedisLockClient redisLockClient(MicaLockProperties properties) {
        return new RedisLockClientImpl(MicaLockAutoConfiguration.redissonClient(properties));
    }

    @Bean
    @ConditionalOnMissingBean
    public RedisLockAspect redisLockAspect(RedisLockClient redisLockClient) {
        return new RedisLockAspect(redisLockClient);
    }

    private static RedissonClient redissonClient(MicaLockProperties properties) {
        Config config;
        MicaLockProperties.Mode mode = properties.getMode();
        switch (mode) {
            case sentinel: {
                config = MicaLockAutoConfiguration.sentinelConfig(properties);
                break;
            }
            case cluster: {
                config = MicaLockAutoConfiguration.clusterConfig(properties);
                break;
            }
            case master: {
                config = MicaLockAutoConfiguration.masterSlaveConfig(properties);
                break;
            }
            case single: {
                config = MicaLockAutoConfiguration.singleConfig(properties);
                break;
            }
            default: {
                config = new Config();
            }
        }
        return Redisson.create((Config)config);
    }
}

