/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.mica.mybatis.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.baomidou.mybatisplus.extension.toolkit.SqlHelper;
import java.util.Collection;
import net.dreamlu.mica.mybatis.injector.MicaSqlMethod;
import net.dreamlu.mica.mybatis.mapper.MicaMapper;
import net.dreamlu.mica.mybatis.service.MicaService;
import org.apache.ibatis.session.SqlSession;
import org.springframework.transaction.annotation.Transactional;

public class MicaServiceImpl<M extends MicaMapper<T>, T>
extends ServiceImpl<M, T>
implements MicaService<T> {
    @Override
    public boolean saveIgnore(T entity) {
        return this.retBool(((MicaMapper)this.baseMapper).insertIgnore(entity));
    }

    @Override
    public boolean saveReplace(T entity) {
        return this.retBool(((MicaMapper)this.baseMapper).replace(entity));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean saveIgnoreBatch(Collection<T> entityList, int batchSize) {
        return this.saveBatch(entityList, batchSize, MicaSqlMethod.INSERT_IGNORE_ONE);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean saveReplaceBatch(Collection<T> entityList, int batchSize) {
        return this.saveBatch(entityList, batchSize, MicaSqlMethod.REPLACE_ONE);
    }

    private boolean saveBatch(Collection<T> entityList, int batchSize, MicaSqlMethod sqlMethod) {
        String sqlStatement = this.micaSqlStatement(sqlMethod);
        try (SqlSession batchSqlSession = this.sqlSessionBatch();){
            int i = 0;
            for (T anEntityList : entityList) {
                batchSqlSession.insert(sqlStatement, anEntityList);
                if (i >= 1 && i % batchSize == 0) {
                    batchSqlSession.flushStatements();
                }
                ++i;
            }
            batchSqlSession.flushStatements();
        }
        return true;
    }

    protected String micaSqlStatement(MicaSqlMethod sqlMethod) {
        return SqlHelper.table((Class)this.currentModelClass()).getSqlStatement(sqlMethod.getMethod());
    }
}

