/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.mica.redis.stream;

import java.util.Collections;
import java.util.Map;
import org.springframework.data.redis.connection.stream.MapRecord;
import org.springframework.data.redis.connection.stream.ObjectRecord;
import org.springframework.data.redis.connection.stream.Record;
import org.springframework.data.redis.connection.stream.RecordId;
import org.springframework.lang.Nullable;

public interface RStreamTemplate {
    public static final String OBJECT_PAYLOAD_KEY = "@payload";

    default public RecordId send(String name, Object value) {
        return this.send((Record<String, ?>)ObjectRecord.create((Object)name, (Object)value));
    }

    default public RecordId send(String name, String key, Object value) {
        return this.send(name, Collections.singletonMap(key, value));
    }

    default public RecordId send(String name, Map<String, Object> messages) {
        return this.send((Record<String, ?>)MapRecord.create((Object)name, messages));
    }

    public RecordId send(Record<String, ?> var1);

    @Nullable
    public Long delete(String var1, String ... var2);

    @Nullable
    public Long delete(String var1, RecordId ... var2);

    @Nullable
    default public Long delete(Record<String, ?> record) {
        return this.delete((String)record.getStream(), record.getId());
    }

    @Nullable
    default public Long trim(String name, long count) {
        return this.trim(name, count, false);
    }

    @Nullable
    public Long trim(String var1, long var2, boolean var4);
}

