/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.mica.swagger;

import io.swagger.annotations.Api;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.dreamlu.mica.swagger.MicaSwaggerProperties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.ParameterBuilder;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.schema.ModelRef;
import springfox.documentation.schema.ModelReference;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.ApiKey;
import springfox.documentation.service.AuthorizationScope;
import springfox.documentation.service.Contact;
import springfox.documentation.service.Parameter;
import springfox.documentation.service.SecurityReference;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.service.contexts.SecurityContext;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger.web.ApiKeyVehicle;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={Docket.class})
@EnableConfigurationProperties(value={MicaSwaggerProperties.class})
@ConditionalOnProperty(value={"mica.swagger.enabled"}, havingValue="true", matchIfMissing=true)
@ConditionalOnMissingClass(value={"org.springframework.cloud.gateway.config.GatewayAutoConfiguration"})
public class SwaggerConfiguration {
    @Bean
    public Docket createRestApi(ApplicationContext context, MicaSwaggerProperties properties) {
        String appName = context.getId();
        Docket docket = new Docket(DocumentationType.SWAGGER_2).useDefaultResponseMessages(false).globalOperationParameters(this.globalHeaders(properties)).apiInfo(this.apiInfo(appName, properties)).select().apis(RequestHandlerSelectors.withClassAnnotation(Api.class)).paths(PathSelectors.any()).build();
        if (properties.getAuthorization().getEnabled().booleanValue()) {
            docket.securitySchemes(Collections.singletonList(this.apiKey(properties)));
            docket.securityContexts(Collections.singletonList(this.securityContext(properties)));
        }
        return docket;
    }

    private ApiKey apiKey(MicaSwaggerProperties properties) {
        return new ApiKey(properties.getAuthorization().getName(), properties.getAuthorization().getKeyName(), ApiKeyVehicle.HEADER.getValue());
    }

    private SecurityContext securityContext(MicaSwaggerProperties properties) {
        return SecurityContext.builder().securityReferences(this.defaultAuth(properties)).forPaths(PathSelectors.regex((String)properties.getAuthorization().getAuthRegex())).build();
    }

    private List<SecurityReference> defaultAuth(MicaSwaggerProperties properties) {
        AuthorizationScope authorizationScope = new AuthorizationScope("global", "accessEverything");
        AuthorizationScope[] authorizationScopes = new AuthorizationScope[]{authorizationScope};
        return Collections.singletonList(SecurityReference.builder().reference(properties.getAuthorization().getName()).scopes(authorizationScopes).build());
    }

    private ApiInfo apiInfo(String appName, MicaSwaggerProperties properties) {
        String defaultName = appName + " \u670d\u52a1";
        String title = Optional.ofNullable(properties.getTitle()).orElse(defaultName);
        String description = Optional.ofNullable(properties.getDescription()).orElse(defaultName);
        return new ApiInfoBuilder().title(title).description(description).version(properties.getVersion()).contact(new Contact(properties.getContactUser(), properties.getContactUrl(), properties.getContactEmail())).build();
    }

    private List<Parameter> globalHeaders(MicaSwaggerProperties properties) {
        return properties.getHeaders().stream().map(header -> new ParameterBuilder().name(header.getName()).description(header.getDescription()).modelRef((ModelReference)new ModelRef("string")).parameterType("header").required(header.isRequired()).build()).collect(Collectors.toList());
    }
}

